/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowvis.data.CompoundGraphBuilder;
import org.glowvis.data.RenderableEdge;
import org.glowvis.data.RenderableNode;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;

public class CompoundGraph {
    private Table m_nodes;
    private Table m_adjacencies;
    private Table m_inclusions;
    private String m_itemrefkey;
    private String m_nodekey;
    private String m_sourcekey;
    private String m_targetkey;
    private static final String DEFAULT_ITEMREF = "glow.compoundgraph.itemref";
    private static final String DEFAULT_NODE_KEY = null;
    private static final String DEFAULT_SOURCE_KEY = "glow.compoundgraph.sourcekey";
    private static final String DEFAULT_TARGET_KEY = "glow.compoundgraph.targetkey";

    public static CompoundGraphBuilder createBuilder() {
        return new PrefuseCompoundGraphBuilder();
    }

    private CompoundGraph() {
        this(DEFAULT_ITEMREF, DEFAULT_NODE_KEY, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    private CompoundGraph(String string, String string2, String string3, String string4) {
        this.m_itemrefkey = string;
        this.m_nodekey = string2;
        this.m_sourcekey = string3;
        this.m_targetkey = string4;
        this.m_nodes = new Table();
        this.m_nodes.addColumn(this.m_itemrefkey, RenderableNode.class, null);
        this.m_inclusions = new Table();
        this.m_inclusions.addColumn(this.m_sourcekey, Integer.TYPE, (Object)-1);
        this.m_inclusions.addColumn(this.m_targetkey, Integer.TYPE, (Object)-1);
        this.m_adjacencies = new Table();
        this.m_adjacencies.addColumn(this.m_sourcekey, Integer.TYPE, (Object)-1);
        this.m_adjacencies.addColumn(this.m_targetkey, Integer.TYPE, (Object)-1);
    }

    public Tree asInclusionTree() {
        return new Tree(this.m_nodes, this.m_inclusions, this.m_nodekey, this.m_sourcekey, this.m_targetkey);
    }

    public Graph asAdjacencyGraph() {
        return new Graph(this.m_nodes, this.m_adjacencies, true, this.m_nodekey, this.m_sourcekey, this.m_targetkey);
    }

    public String getItemRefKey() {
        return this.m_itemrefkey;
    }

    public String getNodeKey() {
        return this.m_nodekey;
    }

    public String getSourceKey() {
        return this.m_sourcekey;
    }

    public String getTargetKey() {
        return this.m_targetkey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrefuseCompoundGraphBuilder
    implements CompoundGraphBuilder {
        private CompoundGraph m_compoundgraph = new CompoundGraph();
        private Map<String, Integer> m_nodelookup = new HashMap<String, Integer>();
        private static final String NODEPARAM_NEXT_EQUIVALENCE_INDEX = "_next_equivalence_index";
        private static final Schema NODEPARAMS = new Schema();

        private PrefuseCompoundGraphBuilder() {
            this.initializeSchemas((TupleSet)this.m_compoundgraph.m_nodes);
        }

        @Override
        public void addRoot(RenderableNode renderableNode) {
            if (this.m_compoundgraph.m_nodes.getRowCount() > 0) {
                throw new IllegalStateException("The root node must be the first node to be added to the graph.");
            }
            this.checkedAddNode(renderableNode, false);
        }

        @Override
        public void addInclusion(RenderableEdge renderableEdge) {
            int n = this.checkedAddNode(renderableEdge.getSource(), false);
            int n2 = this.checkedAddNode(renderableEdge.getTarget(), true);
            int n3 = this.getInclusionsTable().addRow();
            Tuple tuple = this.getInclusionsTable().getTuple(n3);
            tuple.set(this.m_compoundgraph.m_sourcekey, (Object)n);
            tuple.set(this.m_compoundgraph.m_targetkey, (Object)n2);
        }

        @Override
        public void addAdjacencyEdge(RenderableEdge renderableEdge) {
            int n = this.checkedAddNode(renderableEdge.getSource(), false);
            int n2 = this.checkedAddNode(renderableEdge.getTarget(), false);
            for (Tuple tuple : this.getClones(n)) {
                for (Tuple tuple2 : this.getClones(n2)) {
                    int n3 = this.getAdjacenciesTable().addRow();
                    Tuple tuple3 = this.getAdjacenciesTable().getTuple(n3);
                    tuple3.set(this.m_compoundgraph.m_sourcekey, (Object)tuple.getRow());
                    tuple3.set(this.m_compoundgraph.m_targetkey, (Object)tuple2.getRow());
                }
            }
        }

        @Override
        public CompoundGraph getCompoundGraph() {
            return this.m_compoundgraph;
        }

        private Table getNodesTable() {
            return this.getCompoundGraph().m_nodes;
        }

        private Table getInclusionsTable() {
            return this.getCompoundGraph().m_inclusions;
        }

        private Table getAdjacenciesTable() {
            return this.getCompoundGraph().m_adjacencies;
        }

        private boolean hasClones(int n) {
            Node node = (Node)this.getNodesTable().getTuple(n);
            return node.getInt(NODEPARAM_NEXT_EQUIVALENCE_INDEX) != n;
        }

        private List<Tuple> getClones(int n) {
            Tuple tuple = this.getNodesTable().getTuple(n);
            ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
            arrayList.add(tuple);
            int n2 = tuple.getInt(NODEPARAM_NEXT_EQUIVALENCE_INDEX);
            while (n2 != n) {
                tuple = this.getNodesTable().getTuple(n2);
                arrayList.add(tuple);
                n2 = tuple.getInt(NODEPARAM_NEXT_EQUIVALENCE_INDEX);
            }
            return arrayList;
        }

        private int checkedAddNode(RenderableNode renderableNode, boolean bl) {
            String string = renderableNode.getKey();
            if (this.m_nodelookup.containsKey(string)) {
                int n = this.m_nodelookup.get(string);
                return bl ? this.addClonedNode(n) : this.m_nodelookup.get(renderableNode.getKey()).intValue();
            }
            return this.addNewNode(renderableNode);
        }

        private int addNewNode(RenderableNode renderableNode) {
            int n = this.getNodesTable().addRow();
            Tuple tuple = this.getNodesTable().getTuple(n);
            tuple.set(this.m_compoundgraph.getItemRefKey(), (Object)renderableNode);
            tuple.setInt(NODEPARAM_NEXT_EQUIVALENCE_INDEX, n);
            this.m_nodelookup.put(renderableNode.getKey(), n);
            return n;
        }

        private int addClonedNode(int n) {
            Tuple tuple = this.getNodesTable().getTuple(n);
            int n2 = this.getNodesTable().addRow();
            Tuple tuple2 = this.getNodesTable().getTuple(n2);
            RenderableNode renderableNode = (RenderableNode)tuple.get(this.m_compoundgraph.getItemRefKey());
            tuple2.set(this.m_compoundgraph.getItemRefKey(), (Object)renderableNode);
            int n3 = tuple.getInt(NODEPARAM_NEXT_EQUIVALENCE_INDEX);
            tuple.setInt(NODEPARAM_NEXT_EQUIVALENCE_INDEX, n2);
            tuple2.setInt(NODEPARAM_NEXT_EQUIVALENCE_INDEX, n3);
            return n2;
        }

        private void initializeSchemas(TupleSet tupleSet) {
            tupleSet.addColumns(NODEPARAMS);
        }

        static {
            NODEPARAMS.addColumn(NODEPARAM_NEXT_EQUIVALENCE_INDEX, Integer.TYPE, (Object)-1);
        }
    }
}

