/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private String m_name;
    private Map<String, ConfigurationItem> m_items;
    private Map<String, Configuration> m_subgroups;
    private static final String DEFAULT_NAME_MAIN = "Main";

    public Configuration() {
        this(DEFAULT_NAME_MAIN);
    }

    public Configuration(String string) {
        this.m_name = string;
        this.m_items = new HashMap<String, ConfigurationItem>();
        this.m_subgroups = new HashMap<String, Configuration>();
    }

    public String getName() {
        return this.m_name;
    }

    public boolean hasItem(String string) {
        return this.m_items.containsKey(string);
    }

    public ConfigurationItem getItem(String string) {
        return this.m_items.get(string);
    }

    public Collection<ConfigurationItem> getAllItems() {
        return this.m_items.values();
    }

    public void addItem(ConfigurationItem configurationItem) {
        this.m_items.put(configurationItem.getName(), configurationItem);
    }

    public boolean hasSubgroup(String string) {
        return this.m_subgroups.containsKey(string);
    }

    public Configuration getSubgroup(String string) {
        return this.m_subgroups.get(string);
    }

    public void addSubgroup(Configuration configuration) {
        this.m_subgroups.put(configuration.getName(), configuration);
    }

    public Collection<Configuration> getAllSubgroups() {
        return this.m_subgroups.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationEnumItem<T extends Enum<T>>
    extends ConfigurationItem {
        private Set<T> m_items;

        public ConfigurationEnumItem(String string, Set<T> set, T t) {
            super(string, t);
            this.m_items = set;
        }

        public Set<T> getItems() {
            return this.m_items;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationOptionItem
    extends ConfigurationItem {
        private Map<Integer, String> m_options;

        public ConfigurationOptionItem(String string, Map<Integer, String> map, int n) {
            super(string, n);
            this.m_options = map;
        }

        public Map<Integer, String> getOptions() {
            return this.m_options;
        }
    }

    public static class ConfigurationNumericalItem
    extends ConfigurationItem {
        private Object m_min;
        private Object m_max;

        public ConfigurationNumericalItem(String string, Object object, Object object2, Object object3) {
            super(string, object);
            this.m_min = object2;
            this.m_max = object3;
        }

        public Object getMinValue() {
            return this.m_min;
        }

        public Object getMaxValue() {
            return this.m_max;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationItem {
        private String m_itemname;
        private Object m_value;

        public ConfigurationItem(String string, Object object) {
            this.m_itemname = string;
            this.m_value = object;
        }

        public String getName() {
            return this.m_itemname;
        }

        public Class<?> getValueType() {
            return this.m_value.getClass();
        }

        public Object getValue() {
            return this.m_value;
        }

        public void setValue(Object object) {
            this.m_value = object;
        }
    }
}

