/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl;

import com.sun.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.JComponent;
import org.glowvis.data.Configuration;
import org.glowvis.vis.util.GLTransforms;
import prefuse.Visualization;
import prefuse.controls.Control;
import prefuse.data.expression.Predicate;
import prefuse.render.Renderer;
import prefuse.util.StringLib;
import prefuse.util.display.Clip;
import prefuse.util.display.RenderingQueue;
import prefuse.visual.VisualItem;

public class GLDisplay
extends JComponent
implements GLEventListener {
    private static final long serialVersionUID = -7150526274774751894L;
    private static final Logger s_logger = Logger.getLogger(GLDisplay.class.getName());
    protected Visualization m_vis;
    private Predicate m_predicate;
    private RenderingQueue m_queue;
    private AffineTransform m_transform;
    private AffineTransform m_itransform;
    private Rectangle2D m_rclip;
    private Clip m_bounds;
    private final List<Control> m_controls;
    private GLAutoDrawable m_autodrawable;
    private DisplayConfiguration m_config;

    public GLDisplay(DisplayConfiguration displayConfiguration) {
        this(displayConfiguration, null, null);
    }

    public GLDisplay(DisplayConfiguration displayConfiguration, Visualization visualization, Predicate predicate) {
        this.m_vis = visualization;
        this.m_predicate = predicate;
        this.m_config = displayConfiguration;
        this.m_queue = new RenderingQueue();
        this.m_transform = new AffineTransform();
        this.m_itransform = new AffineTransform();
        this.m_rclip = new Rectangle2D.Double();
        this.m_bounds = new Clip();
        this.m_controls = new CopyOnWriteArrayList<Control>();
        this.setLayout(new BorderLayout());
        this.m_autodrawable = this.isLightWeight() ? new GLJPanel() : new GLCanvas();
        this.m_autodrawable.addGLEventListener((GLEventListener)this);
        assert (this.m_autodrawable instanceof Component);
        Component component = (Component)this.m_autodrawable;
        InputEventCapturer inputEventCapturer = new InputEventCapturer();
        component.addMouseListener(inputEventCapturer);
        component.addMouseMotionListener(inputEventCapturer);
        component.addMouseWheelListener(inputEventCapturer);
        component.addKeyListener(inputEventCapturer);
        this.add(component);
        new Animator(this.m_autodrawable).start();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glHint(3152, 4354);
        gL2.glShadeModel(7425);
        gL2.glEnable(2848);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        this.reshape(gLAutoDrawable, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.clearDisplay(gL2);
        this.performGLProjectionTransform(gL2);
        gL2.glMatrixMode(5888);
        this.render();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glOrtho((double)n, (double)(n + n3), (double)(n2 + n4), (double)n2, -1.0, 1.0);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    private void clearDisplay(GL2 gL2) {
        gL2.glClear(256);
        gL2.glClearDepth(1.0);
        float[] fArray = new float[3];
        this.getBackgroundColor().getColorComponents(fArray);
        gL2.glClearColor(fArray[0], fArray[1], fArray[2], 0.0f);
        gL2.glClear(16384);
    }

    private void performGLProjectionTransform(GL2 gL2) {
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glOrtho((double)this.getX(), (double)(this.getX() + this.getWidth()), (double)(this.getY() + this.getHeight()), (double)this.getY(), -1.0, 1.0);
        gL2.glMultMatrixd(GLTransforms.toGLMatrix(this.m_transform), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render() {
        Visualization visualization = this.m_vis;
        synchronized (visualization) {
            GLDisplay gLDisplay = this;
            synchronized (gLDisplay) {
                VisualItem visualItem;
                this.getItemBounds(this.m_rclip);
                this.m_bounds.reset();
                this.m_queue.clear();
                int n = 0;
                Iterator iterator = this.m_vis.items(this.m_predicate);
                while (iterator.hasNext()) {
                    visualItem = (VisualItem)iterator.next();
                    this.m_bounds.union(visualItem.getBounds());
                    this.m_queue.addToRenderQueue(visualItem);
                    ++n;
                }
                this.m_queue.sortRenderQueue();
                for (int i = 0; i < this.m_queue.rsize; ++i) {
                    visualItem = this.m_queue.ritems[i];
                    Renderer renderer = visualItem.getRenderer();
                    renderer.render(null, visualItem);
                }
            }
        }
    }

    public synchronized void pan(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.m_itransform.transform(double_, double_);
        double d3 = ((Point2D)double_).getX();
        double d4 = ((Point2D)double_).getY();
        ((Point2D)double_).setLocation(0.0, 0.0);
        this.m_itransform.transform(double_, double_);
        this.panAbs(d3 -= ((Point2D)double_).getX(), d4 -= ((Point2D)double_).getY());
    }

    public synchronized void panAbs(double d, double d2) {
        this.m_transform.translate(d, d2);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Point2D getAbsoluteCoordinate(Point2D point2D, Point2D point2D2) {
        return this.m_itransform.transform(point2D, point2D2);
    }

    public synchronized Rectangle2D getItemBounds(Rectangle2D rectangle2D) {
        rectangle2D.setFrameFromDiagonal(this.m_bounds.getMinX(), this.m_bounds.getMinY(), this.m_bounds.getMaxX(), this.m_bounds.getMaxY());
        return rectangle2D;
    }

    public AffineTransform getTransform() {
        return this.m_transform;
    }

    public AffineTransform getInverseTransform() {
        return this.m_itransform;
    }

    public double getScale() {
        return this.m_transform.getScaleX();
    }

    public synchronized void zoom(Point2D point2D, double d) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.zoomAbs(double_, d);
    }

    public synchronized void zoomAbs(Point2D point2D, double d) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        this.m_transform.translate(d2, d3);
        this.m_transform.scale(d, d);
        this.m_transform.translate(-d2, -d3);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void rotate(Point2D point2D, double d) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.rotateAbs(double_, d);
    }

    public synchronized void rotateAbs(Point2D point2D, double d) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        this.m_transform.translate(d2, d3);
        this.m_transform.rotate(d);
        this.m_transform.translate(-d2, -d3);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isLightWeight() {
        return this.getConfiguration().isLightweight();
    }

    public Color getBackgroundColor() {
        return this.getConfiguration().getBackgroundColor();
    }

    protected DisplayConfiguration getConfiguration() {
        return this.m_config;
    }

    public GL2 getGLRenderContext() {
        GL gL = this.m_autodrawable.getGL();
        assert (gL != null && gL.isGL2());
        return this.m_autodrawable.getGL().getGL2();
    }

    public void addControlListener(Control control) {
        this.m_controls.add(control);
    }

    public void removeControlListener(Control control) {
        this.m_controls.remove(control);
    }

    public static class DisplayConfiguration
    extends Configuration {
        private Color m_backgroundcolor = Color.WHITE;
        private Weightedness m_weightedness = Weightedness.HEAVYWEIGHT;

        public DisplayConfiguration(String string) {
            super(string);
        }

        public Color getBackgroundColor() {
            return this.m_backgroundcolor;
        }

        public DisplayConfiguration setBackgroundColor(Color color) {
            this.m_backgroundcolor = color;
            return this;
        }

        public boolean isLightweight() {
            return this.m_weightedness == Weightedness.LIGHTWEIGHT;
        }

        public boolean isHeavyweight() {
            return this.m_weightedness == Weightedness.HEAVYWEIGHT;
        }

        public DisplayConfiguration setWeightedness(Weightedness weightedness) {
            this.m_weightedness = weightedness;
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Weightedness {
            LIGHTWEIGHT,
            HEAVYWEIGHT;

        }
    }

    public class InputEventCapturer
    implements MouseMotionListener,
    MouseWheelListener,
    MouseListener,
    KeyListener {
        private VisualItem activeItem = null;
        private boolean mouseDown = false;

        private boolean validityCheck() {
            if (this.activeItem.isValid()) {
                return true;
            }
            this.activeItem = null;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent mouseEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemDragged(this.activeItem, mouseEvent);
                    }
                } else {
                    this.fireMouseDragged(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent mouseEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                boolean bl = false;
                VisualItem visualItem = null;
                if (this.activeItem != null && this.activeItem != visualItem) {
                    if (this.validityCheck()) {
                        this.fireItemExited(this.activeItem, mouseEvent);
                    }
                    bl = true;
                }
                if (visualItem != null && visualItem != this.activeItem) {
                    this.fireItemEntered(visualItem, mouseEvent);
                    bl = true;
                }
                this.activeItem = visualItem;
                if (bl) {
                    return;
                }
                if (visualItem != null && visualItem == this.activeItem) {
                    this.fireItemMoved(visualItem, mouseEvent);
                }
                if (visualItem == null) {
                    this.fireMouseMoved(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemWheelMoved(this.activeItem, mouseWheelEvent);
                    }
                } else {
                    this.fireMouseWheelMoved(mouseWheelEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent mouseEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemClicked(this.activeItem, mouseEvent);
                    }
                } else {
                    this.fireMouseClicked(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent mouseEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                this.mouseDown = true;
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemPressed(this.activeItem, mouseEvent);
                    }
                } else {
                    this.fireMousePressed(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemReleased(this.activeItem, mouseEvent);
                    }
                } else {
                    this.fireMouseReleased(mouseEvent);
                }
                if (this.activeItem != null && this.mouseDown && this.isOffComponent(mouseEvent)) {
                    this.fireItemExited(this.activeItem, mouseEvent);
                    this.activeItem = null;
                }
                this.mouseDown = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseEntered(MouseEvent mouseEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                this.fireMouseEntered(mouseEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseExited(MouseEvent mouseEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                if (!this.mouseDown && this.activeItem != null) {
                    this.fireItemExited(this.activeItem, mouseEvent);
                    this.activeItem = null;
                }
                this.fireMouseExited(mouseEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent keyEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyPressed(this.activeItem, keyEvent);
                    }
                } else {
                    this.fireKeyPressed(keyEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyReleased(KeyEvent keyEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyReleased(this.activeItem, keyEvent);
                    }
                } else {
                    this.fireKeyReleased(keyEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyTyped(KeyEvent keyEvent) {
            Visualization visualization = GLDisplay.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyTyped(this.activeItem, keyEvent);
                    }
                } else {
                    this.fireKeyTyped(keyEvent);
                }
            }
        }

        private boolean isOffComponent(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            return n < 0 || n > GLDisplay.this.getWidth() || n2 < 0 || n2 > GLDisplay.this.getHeight();
        }

        private void fireItemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemDragged(visualItem, mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemMoved(VisualItem visualItem, MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemMoved(visualItem, mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemWheelMoved(VisualItem visualItem, MouseWheelEvent mouseWheelEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemWheelMoved(visualItem, mouseWheelEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemClicked(visualItem, mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemPressed(visualItem, mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemReleased(visualItem, mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
            visualItem.setHover(true);
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemEntered(visualItem, mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemExited(VisualItem visualItem, MouseEvent mouseEvent) {
            if (visualItem.isValid()) {
                visualItem.setHover(false);
            }
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemExited(visualItem, mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemKeyPressed(VisualItem visualItem, KeyEvent keyEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyPressed(visualItem, keyEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemKeyReleased(VisualItem visualItem, KeyEvent keyEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyReleased(visualItem, keyEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireItemKeyTyped(VisualItem visualItem, KeyEvent keyEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyTyped(visualItem, keyEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireMouseEntered(MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.mouseEntered(mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireMouseExited(MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.mouseExited(mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireMousePressed(MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.mousePressed(mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireMouseReleased(MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.mouseReleased(mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireMouseClicked(MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.mouseClicked(mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireMouseDragged(MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.mouseDragged(mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireMouseMoved(MouseEvent mouseEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.mouseMoved(mouseEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.mouseWheelMoved(mouseWheelEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireKeyPressed(KeyEvent keyEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.keyPressed(keyEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireKeyReleased(KeyEvent keyEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.keyReleased(keyEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }

        private void fireKeyTyped(KeyEvent keyEvent) {
            for (Control control : GLDisplay.this.m_controls) {
                if (!control.isEnabled()) continue;
                try {
                    control.keyTyped(keyEvent);
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace((Throwable)exception));
                }
            }
        }
    }
}

