/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl;

import java.awt.Color;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glowvis.data.CompoundGraph;
import org.glowvis.data.Configuration;
import org.glowvis.vis.gl.GLDisplay;
import org.glowvis.vis.gl.controls.GLPanControl;
import org.glowvis.vis.gl.controls.GLRotationControl;
import org.glowvis.vis.gl.controls.GLZoomControl;
import org.glowvis.vis.gl.render.GLEdgeRenderer;
import org.glowvis.vis.gl.render.GLHierarchicallyBundledEdgeRenderer;
import org.glowvis.vis.gl.render.GLLabelRenderer;
import org.glowvis.vis.gl.render.GLNodeRenderer;
import org.glowvis.vis.gl.render.GLRendererAdapter;
import org.glowvis.vis.gl.render.GLRingSegmentRenderer;
import org.glowvis.vis.gl.render.GLSimpleEdgeRenderer;
import org.glowvis.vis.layout.CompoundGraphLayout;
import org.glowvis.vis.layout.InvertedRadialTreeLayout;
import org.glowvis.vis.text.GLTextRenderer;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.layout.Layout;
import prefuse.action.layout.graph.BalloonTreeLayout;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.action.layout.graph.NodeLinkTreeLayout;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.action.layout.graph.SquarifiedTreeMapLayout;
import prefuse.controls.Control;
import prefuse.render.NullRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.visual.VisualItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLRadialCompoundGraphDisplay
extends GLDisplay {
    private static final long serialVersionUID = 3379575252196282248L;
    private static final String INCLUSIONS_GROUPNAME = "inclusions";
    private static final String ADJACENCIES_GROUPNAME = "adjacencies";
    private Configuration m_appconfiguration;
    public static final String CONFIGURATION_LAYOUT = "Layout";
    public static final String CONFIGURATION_BETA = "Bundling Coefficient";
    public static final String CONFIGURATION_BACKGROUND_COLOR = "Background color";
    public static final String CONFIGURATION_ADJACENCY_EDGE_SOURCE_COLOR = "Adjacency edge source color";
    public static final String CONFIGURATION_ADJACENCY_EDGE_TARGET_COLOR = "Adjacency edge target color";
    public static final String CONFIGURATION_INCLUSION_EDGE_SHOW = "Show inclusion edges";
    public static final String CONFIGURATION_INCLUSION_EDGE_SOURCE_COLOR = "Inclusion edge source color";
    public static final String CONFIGURATION_INCLUSION_EDGE_TARGET_COLOR = "Inclusion edge target color";
    public static final String CONFIGURATION_DISPLAY_GROUP = "Display";
    public static final String CONFIGURATION_NODE_GROUP = "Nodes";
    public static final String CONFIGURATION_LABEL_GROUP = "Labels";
    public static final String CONFIGURATION_INCLUSIONEDGE_GROUP = "Inclusion edges";
    public static final String CONFIGURATION_ADJACENCYEDGE_GROUP = "Adjacency edges";

    public GLRadialCompoundGraphDisplay() {
        this(GLRadialCompoundGraphDisplay.createDefaultConfiguration());
    }

    public GLRadialCompoundGraphDisplay(Configuration configuration) {
        super((GLDisplay.DisplayConfiguration)configuration.getSubgroup(CONFIGURATION_DISPLAY_GROUP));
        this.addControlListener((Control)new GLRotationControl(this, 8));
        this.addControlListener((Control)new GLPanControl(this));
        this.addControlListener((Control)new GLZoomControl(this));
        this.m_appconfiguration = configuration;
    }

    public void setGraph(CompoundGraph compoundGraph) {
        this.initVisualization(compoundGraph);
    }

    public Configuration getApplicationConfiguration() {
        return this.m_appconfiguration;
    }

    public void setApplicationConfiguration(Configuration configuration) {
        this.m_appconfiguration = configuration;
    }

    public static Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.addItem(new Configuration.ConfigurationEnumItem<GraphLayoutOption>(CONFIGURATION_LAYOUT, GLRadialCompoundGraphDisplay.enumerateLayouts(), GraphLayoutOption.INVERTED_RADIAL));
        configuration.addSubgroup(new GLDisplay.DisplayConfiguration(CONFIGURATION_DISPLAY_GROUP));
        configuration.addSubgroup(new GLNodeRenderer.GLNodeRendererConfiguration(CONFIGURATION_NODE_GROUP).setNodeColor(Color.WHITE));
        configuration.addSubgroup(new GLLabelRenderer.GLLabelRendererConfiguration(CONFIGURATION_LABEL_GROUP).setNodeColor(Color.BLACK));
        configuration.addSubgroup(new GLEdgeRenderer.GLEdgeRendererConfiguration(CONFIGURATION_INCLUSIONEDGE_GROUP).setSourceColor(Color.BLACK).setTargetColor(Color.BLACK).setAlphaComponent(0.4).setEdgeWidth(2.5));
        configuration.addSubgroup(new GLHierarchicallyBundledEdgeRenderer.GLBundlingEdgeRendererConfiguration(CONFIGURATION_ADJACENCYEDGE_GROUP).setBundlingCoefficient(0.75).setSourceColor(Color.RED).setTargetColor(Color.GREEN).setAlphaComponent(0.6).setEdgeWidth(2.5));
        return configuration;
    }

    private void initVisualization(CompoundGraph compoundGraph) {
        if (this.m_vis != null) {
            this.m_vis.cancel("layouts");
        }
        Visualization visualization = new Visualization();
        visualization.addTree(INCLUSIONS_GROUPNAME, compoundGraph.asInclusionTree());
        visualization.addGraph(ADJACENCIES_GROUPNAME, compoundGraph.asAdjacencyGraph());
        visualization.setRendererFactory((RendererFactory)new RadialCompoundGraphRendererFactory());
        GraphLayoutOption graphLayoutOption = (GraphLayoutOption)((Object)this.m_appconfiguration.getItem(CONFIGURATION_LAYOUT).getValue());
        Layout layout = graphLayoutOption.create(INCLUSIONS_GROUPNAME);
        CompoundGraphLayout.NodeTransformPolicy nodeTransformPolicy = layout instanceof InvertedRadialTreeLayout ? ((InvertedRadialTreeLayout)layout).getNodeTransformPolicy() : new CompoundGraphLayout.NodeCopyCoordinatesPolicy();
        CompoundGraphLayout compoundGraphLayout = new CompoundGraphLayout(INCLUSIONS_GROUPNAME, ADJACENCIES_GROUPNAME, nodeTransformPolicy);
        long l = layout instanceof ForceDirectedLayout ? -1L : 0L;
        ActionList actionList = new ActionList(l);
        actionList.add((Action)layout);
        actionList.add((Action)compoundGraphLayout);
        visualization.putAction("layouts", (Action)actionList);
        this.m_vis = visualization;
        visualization.run("layouts");
    }

    private boolean renderNodesAsRadialSegments() {
        GraphLayoutOption graphLayoutOption = (GraphLayoutOption)((Object)this.m_appconfiguration.getItem(CONFIGURATION_LAYOUT).getValue());
        return graphLayoutOption == GraphLayoutOption.INVERTED_RADIAL;
    }

    private static Set<GraphLayoutOption> enumerateLayouts() {
        return EnumSet.of(GraphLayoutOption.INVERTED_RADIAL, GraphLayoutOption.FORCE_DIRECTED, GraphLayoutOption.SQUARIFIED_TREEMAP, GraphLayoutOption.NODELINK);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphLayoutOption {
        FORCE_DIRECTED("Force-directed Graph"){

            public Layout create(String string) {
                return new ForceDirectedLayout(string);
            }
        }
        ,
        INVERTED_RADIAL("Inverted Radial Tree"){

            public Layout create(String string) {
                return new InvertedRadialTreeLayout(string);
            }
        }
        ,
        NODELINK("Node-link Tree"){

            public Layout create(String string) {
                return new NodeLinkTreeLayout(string, 2, 100.0, 5.0, 25.0);
            }
        }
        ,
        SQUARIFIED_TREEMAP("Squarified TreeMap"){

            public Layout create(String string) {
                return new SquarifiedTreeMapLayout(string);
            }
        }
        ,
        RADIAL("Radial Tree"){

            public Layout create(String string) {
                return new RadialTreeLayout(string);
            }
        }
        ,
        BALLOON("Balloon Tree"){

            public Layout create(String string) {
                return new BalloonTreeLayout(string);
            }
        };

        private final String m_name;

        private GraphLayoutOption(String string2) {
            this.m_name = string2;
        }

        public String toString() {
            return this.m_name;
        }

        public abstract Layout create(String var1);
    }

    private class RadialCompoundGraphRendererFactory
    implements RendererFactory {
        private Map<String, Renderer> m_renderers = new HashMap<String, Renderer>();
        private Renderer m_nullrenderer = new NullRenderer();

        public RadialCompoundGraphRendererFactory() {
            GLNodeRenderer.GLNodeRendererConfiguration gLNodeRendererConfiguration = (GLNodeRenderer.GLNodeRendererConfiguration)GLRadialCompoundGraphDisplay.this.getApplicationConfiguration().getSubgroup(GLRadialCompoundGraphDisplay.CONFIGURATION_NODE_GROUP);
            GLLabelRenderer.GLLabelRendererConfiguration gLLabelRendererConfiguration = (GLLabelRenderer.GLLabelRendererConfiguration)GLRadialCompoundGraphDisplay.this.getApplicationConfiguration().getSubgroup(GLRadialCompoundGraphDisplay.CONFIGURATION_LABEL_GROUP);
            GLEdgeRenderer.GLEdgeRendererConfiguration gLEdgeRendererConfiguration = (GLEdgeRenderer.GLEdgeRendererConfiguration)GLRadialCompoundGraphDisplay.this.getApplicationConfiguration().getSubgroup(GLRadialCompoundGraphDisplay.CONFIGURATION_INCLUSIONEDGE_GROUP);
            GLHierarchicallyBundledEdgeRenderer.GLBundlingEdgeRendererConfiguration gLBundlingEdgeRendererConfiguration = (GLHierarchicallyBundledEdgeRenderer.GLBundlingEdgeRendererConfiguration)GLRadialCompoundGraphDisplay.this.getApplicationConfiguration().getSubgroup(GLRadialCompoundGraphDisplay.CONFIGURATION_ADJACENCYEDGE_GROUP);
            GLTextRenderer gLTextRenderer = new GLTextRenderer(GLRadialCompoundGraphDisplay.this, gLLabelRendererConfiguration.getFont());
            GLNodeRenderer gLNodeRenderer = GLRadialCompoundGraphDisplay.this.renderNodesAsRadialSegments() ? new GLRingSegmentRenderer(gLNodeRendererConfiguration, gLLabelRendererConfiguration, gLTextRenderer) : new GLLabelRenderer(gLLabelRendererConfiguration, gLTextRenderer);
            this.m_renderers.put("inclusions.nodes", GLRendererAdapter.asRenderer(gLNodeRenderer, GLRadialCompoundGraphDisplay.this));
            GLSimpleEdgeRenderer gLSimpleEdgeRenderer = new GLSimpleEdgeRenderer(gLEdgeRendererConfiguration);
            this.m_renderers.put("inclusions.edges", GLRendererAdapter.asRenderer(gLSimpleEdgeRenderer, GLRadialCompoundGraphDisplay.this));
            GLHierarchicallyBundledEdgeRenderer gLHierarchicallyBundledEdgeRenderer = new GLHierarchicallyBundledEdgeRenderer(gLBundlingEdgeRendererConfiguration);
            this.m_renderers.put("adjacencies.edges", GLRendererAdapter.asRenderer(gLHierarchicallyBundledEdgeRenderer, GLRadialCompoundGraphDisplay.this));
        }

        public Renderer getRenderer(VisualItem visualItem) {
            Renderer renderer = this.m_renderers.get(visualItem.getGroup());
            return renderer != null ? renderer : this.m_nullrenderer;
        }
    }
}

