/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.controls;

import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.glowvis.vis.gl.GLDisplay;
import prefuse.controls.ControlAdapter;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class GLPanControl
extends ControlAdapter {
    private boolean m_panOverItem;
    private int m_xDown;
    private int m_yDown;
    private int m_button;
    private final GLDisplay m_display;

    public GLPanControl(GLDisplay gLDisplay) {
        this(gLDisplay, 16, false);
    }

    public GLPanControl(GLDisplay gLDisplay, boolean bl) {
        this(gLDisplay, 16, bl);
    }

    public GLPanControl(GLDisplay gLDisplay, int n) {
        this(gLDisplay, n, false);
    }

    public GLPanControl(GLDisplay gLDisplay, int n, boolean bl) {
        this.m_button = n;
        this.m_panOverItem = bl;
        this.m_display = gLDisplay;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.m_button)) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(13));
            this.m_xDown = mouseEvent.getX();
            this.m_yDown = mouseEvent.getY();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.m_button)) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.m_xDown;
            int n4 = n2 - this.m_yDown;
            this.m_display.pan(n3, n4);
            this.m_xDown = n;
            this.m_yDown = n2;
            this.m_display.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.m_button)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            this.m_xDown = -1;
            this.m_yDown = -1;
        }
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_panOverItem) {
            this.mousePressed(mouseEvent);
        }
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_panOverItem) {
            this.mouseDragged(mouseEvent);
        }
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_panOverItem) {
            this.mouseReleased(mouseEvent);
        }
    }
}

