/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.controls;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.glowvis.vis.gl.GLDisplay;
import prefuse.controls.ControlAdapter;
import prefuse.util.ui.UILib;

public class GLRotationControl
extends ControlAdapter {
    private Point down = new Point();
    private double baseAngle = 0.0;
    private int m_button;
    private final GLDisplay m_display;

    public GLRotationControl(GLDisplay gLDisplay) {
        this(gLDisplay, 16);
    }

    public GLRotationControl(GLDisplay gLDisplay, int n) {
        this.m_button = n;
        this.m_display = gLDisplay;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.m_button)) {
            this.m_display.setCursor(Cursor.getPredefinedCursor(11));
            this.down.setLocation(mouseEvent.getPoint());
            this.baseAngle = Double.NaN;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.m_button)) {
            int n = mouseEvent.getY() - this.down.y;
            int n2 = mouseEvent.getX() - this.down.x;
            double d = Math.atan2(n, n2);
            if (!Double.isNaN(this.baseAngle)) {
                this.m_display.rotate(this.down, d - this.baseAngle);
            }
            this.baseAngle = d;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.m_button)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

