/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.controls;

import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.glowvis.vis.gl.GLDisplay;
import prefuse.controls.ControlAdapter;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class GLZoomControl
extends ControlAdapter {
    private int yLast;
    private Point2D down = new Point2D.Float();
    private int button = 4;
    private final GLDisplay m_display;
    private boolean m_zoomOverItem = true;
    protected static final int ZOOM = 0;
    protected static final int MIN_ZOOM = 1;
    protected static final int MAX_ZOOM = 2;
    protected static final int NO_ZOOM = 3;
    public static final double DEFAULT_MIN_SCALE = 0.001;
    public static final double DEFAULT_MAX_SCALE = 75.0;
    protected double m_minScale = 0.001;
    protected double m_maxScale = 75.0;

    public GLZoomControl(GLDisplay gLDisplay) {
        this(gLDisplay, 4);
    }

    public GLZoomControl(GLDisplay gLDisplay, int n) {
        this.button = n;
        this.m_display = gLDisplay;
    }

    private int zoom(GLDisplay gLDisplay, Point2D point2D, double d, boolean bl) {
        double d2 = gLDisplay.getScale();
        double d3 = d2 * d;
        int n = 0;
        if (d3 < this.m_minScale) {
            d = this.m_minScale / d2;
            n = 1;
        } else if (d3 > this.m_maxScale) {
            d = this.m_maxScale / d2;
            n = 2;
        }
        if (bl) {
            gLDisplay.zoomAbs(point2D, d);
        } else {
            gLDisplay.zoom(point2D, d);
        }
        gLDisplay.repaint();
        return n;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.button)) {
            this.m_display.setCursor(Cursor.getPredefinedCursor(8));
            this.m_display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.down);
            this.yLast = mouseEvent.getY();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.button)) {
            int n = mouseEvent.getY();
            int n2 = n - this.yLast;
            double d = 1.0 + (double)n2 / 100.0;
            int n3 = this.zoom(this.m_display, this.down, d, true);
            int n4 = 8;
            if (n3 == 3) {
                n4 = 3;
            }
            this.m_display.setCursor(Cursor.getPredefinedCursor(n4));
            this.yLast = n;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.button)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_zoomOverItem) {
            this.mousePressed(mouseEvent);
        }
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_zoomOverItem) {
            this.mouseDragged(mouseEvent);
        }
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_zoomOverItem) {
            this.mouseReleased(mouseEvent);
        }
    }
}

