/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.render;

import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GL2;
import org.glowvis.vis.gl.render.GLRenderStrategy;
import org.glowvis.vis.gl.render.buffer.GLInterleavedRenderBuffer;
import org.glowvis.vis.gl.render.buffer.GLRenderBuffer;
import org.glowvis.vis.gl.render.buffer.GLVertexArrayRenderBuffer;

public class GLBufferRenderStrategy
implements GLRenderStrategy {
    private int m_mode;
    private GLRenderBuffer m_buffer;
    private Set<Integer> m_clientstates;

    public GLBufferRenderStrategy(int n, GLRenderBuffer gLRenderBuffer) {
        this.m_mode = n;
        this.m_buffer = gLRenderBuffer;
        this.m_clientstates = new HashSet<Integer>();
    }

    public void render(GL2 gL2) {
        this.m_buffer.setupRenderStrategy(this, gL2);
        gL2.glPushClientAttrib(2);
        this.enableClientStates(gL2);
        gL2.glDrawArrays(this.m_mode, 0, this.m_buffer.getNumberOfVertices());
        gL2.glPopClientAttrib();
        this.m_clientstates.clear();
    }

    public void setup(GLVertexArrayRenderBuffer gLVertexArrayRenderBuffer, GL2 gL2) {
        this.addClientState(32884);
        gL2.glVertexPointer(gLVertexArrayRenderBuffer.getNumberOfCoords(), gLVertexArrayRenderBuffer.getDataType(), gLVertexArrayRenderBuffer.getStride(), gLVertexArrayRenderBuffer.getData());
    }

    public void setup(GLInterleavedRenderBuffer gLInterleavedRenderBuffer, GL2 gL2) {
        gL2.glInterleavedArrays(gLInterleavedRenderBuffer.getVertexFormat(), gLInterleavedRenderBuffer.getStride(), gLInterleavedRenderBuffer.getData());
    }

    private void addClientState(int n) {
        this.m_clientstates.add(new Integer(n));
    }

    private void enableClientStates(GL2 gL2) {
        for (Integer n : this.m_clientstates) {
            gL2.glEnableClientState(n.intValue());
        }
    }
}

