/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.render;

import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GL2;
import org.glowvis.vis.gl.render.buffer.GLInterleavedRenderBuffer;
import org.glowvis.vis.gl.render.buffer.GLRenderBuffer;
import org.glowvis.vis.gl.render.buffer.GLVertexArrayRenderBuffer;

public class GLBufferRenderer {
    private Set<Integer> m_clientstates = new HashSet<Integer>();

    public void addBuffer(GLRenderBuffer gLRenderBuffer, GL2 gL2) {
        gLRenderBuffer.acceptRenderer(this, gL2);
    }

    public void setup(GLVertexArrayRenderBuffer gLVertexArrayRenderBuffer, GL2 gL2) {
        this.addClientState(32884);
        gL2.glVertexPointer(gLVertexArrayRenderBuffer.getNumberOfCoords(), gLVertexArrayRenderBuffer.getDataType(), gLVertexArrayRenderBuffer.getStride(), gLVertexArrayRenderBuffer.getData());
    }

    public void setup(GLInterleavedRenderBuffer gLInterleavedRenderBuffer, GL2 gL2) {
        gL2.glInterleavedArrays(gLInterleavedRenderBuffer.getVertexFormat(), gLInterleavedRenderBuffer.getStride(), gLInterleavedRenderBuffer.getData());
    }

    public void flushBuffers(GL2 gL2, int n, int n2, int n3) {
        this.drawBuffers(gL2, n, n2, n3);
        this.reset(gL2);
    }

    private void drawBuffers(GL2 gL2, int n, int n2, int n3) {
        this.enableClientStates(gL2);
        gL2.glDrawArrays(n, n2, n3);
    }

    private void reset(GL2 gL2) {
        this.disableClientStates(gL2);
        this.m_clientstates.clear();
    }

    private void addClientState(int n) {
        this.m_clientstates.add(new Integer(n));
    }

    private void enableClientStates(GL2 gL2) {
        for (Integer n : this.m_clientstates) {
            gL2.glEnableClientState(n.intValue());
        }
    }

    private void disableClientStates(GL2 gL2) {
        for (Integer n : this.m_clientstates) {
            gL2.glDisableClientState(n.intValue());
        }
    }
}

