/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.render;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import javax.media.opengl.GL2;
import org.glowvis.vis.gl.render.GLEdgeRenderer;
import prefuse.visual.VisualItem;
import prefuse.visual.tuple.TableEdgeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLHierarchicallyBundledEdgeRenderer
extends GLEdgeRenderer {
    private static int DIMENSIONALITY = 3;
    private static final int[] BASIS = new int[]{-1, 3, -3, 1, 3, -6, 3, 0, -3, 0, 3, 0, 1, 4, 1, 0};

    public GLHierarchicallyBundledEdgeRenderer(GLBundlingEdgeRendererConfiguration gLBundlingEdgeRendererConfiguration) {
        super(gLBundlingEdgeRendererConfiguration);
    }

    @Override
    public void render(GL2 gL2, VisualItem visualItem) {
        if (!this.isEnabled()) {
            return;
        }
        Color color = this.getSourceColor();
        Color color2 = this.getTargetColor();
        double d = this.getBundlingCoefficient();
        TableEdgeItem tableEdgeItem = (TableEdgeItem)visualItem;
        List<VisualItem> list = this.getControlPolygon(tableEdgeItem);
        double[] dArray = this.generateControlCoordinates(list, d);
        gL2.glLineWidth((float)this.getEdgeWidth());
        for (int i = 0; i < list.size() + 3; ++i) {
            this.renderSegment(gL2, i, dArray, 20, color, color2);
        }
    }

    @Override
    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        return false;
    }

    @Override
    public void setBounds(VisualItem visualItem) {
    }

    public double getBundlingCoefficient() {
        return this.getConfiguration().getBundlingCoefficient();
    }

    @Override
    protected GLBundlingEdgeRendererConfiguration getConfiguration() {
        return (GLBundlingEdgeRendererConfiguration)super.getConfiguration();
    }

    private List<VisualItem> getControlPolygon(TableEdgeItem tableEdgeItem) {
        return (List)tableEdgeItem.get("_controlpolygon");
    }

    private double[] generateControlCoordinates(List<VisualItem> list, double d) {
        int n;
        int n2 = list.size();
        double d2 = 1.0 / (double)(n2 - 1);
        double d3 = d;
        double d4 = 1.0 - d;
        VisualItem visualItem = list.get(0);
        VisualItem visualItem2 = list.get(n2 - 1);
        double d5 = visualItem.getX();
        double d6 = visualItem.getY();
        double d7 = visualItem2.getX() - visualItem.getX();
        double d8 = visualItem2.getY() - visualItem.getY();
        double[] dArray = new double[DIMENSIONALITY * (n2 + 6)];
        int n3 = 3 * DIMENSIONALITY;
        for (n = 0; n < n2; ++n) {
            VisualItem visualItem3 = list.get(n);
            double d9 = visualItem3.getX();
            double d10 = visualItem3.getY();
            double d11 = (double)n * d2;
            dArray[n3++] = d3 * d9 + d4 * (d5 + d2 * (double)n * d7);
            dArray[n3++] = d3 * d10 + d4 * (d6 + d2 * (double)n * d8);
            dArray[n3++] = (d3 + d4) * d11;
        }
        n = 3 * DIMENSIONALITY;
        int n4 = n + (n2 - 1) * DIMENSIONALITY;
        for (int i = 0; i <= 3; ++i) {
            int n5 = n - i * DIMENSIONALITY;
            dArray[n5 + 0] = dArray[n + 0];
            dArray[n5 + 1] = dArray[n + 1];
            dArray[n5 + 2] = dArray[n + 2];
            int n6 = n4 + i * DIMENSIONALITY;
            dArray[n6 + 0] = dArray[n4 + 0];
            dArray[n6 + 1] = dArray[n4 + 1];
            dArray[n6 + 2] = dArray[n4 + 2];
        }
        return dArray;
    }

    private void renderSegment(GL2 gL2, int n, double[] dArray, int n2, Color color, Color color2) {
        double[] dArray2 = new double[4 * DIMENSIONALITY];
        int n3 = n * DIMENSIONALITY;
        float[] fArray = new float[3];
        color.getColorComponents(fArray);
        float[] fArray2 = new float[3];
        color2.getColorComponents(fArray2);
        for (int i = 0; i < 4; ++i) {
            int n4 = i * DIMENSIONALITY;
            int n5 = i * 4;
            dArray2[n4 + 0] = ((double)BASIS[n5 + 0] * dArray[n3 + 0] + (double)BASIS[n5 + 1] * dArray[n3 + 3] + (double)BASIS[n5 + 2] * dArray[n3 + 6] + (double)BASIS[n5 + 3] * dArray[n3 + 9]) / 6.0;
            dArray2[n4 + 1] = ((double)BASIS[n5 + 0] * dArray[n3 + 1] + (double)BASIS[n5 + 1] * dArray[n3 + 4] + (double)BASIS[n5 + 2] * dArray[n3 + 7] + (double)BASIS[n5 + 3] * dArray[n3 + 10]) / 6.0;
            dArray2[n4 + 2] = ((double)BASIS[n5 + 0] * dArray[n3 + 2] + (double)BASIS[n5 + 1] * dArray[n3 + 5] + (double)BASIS[n5 + 2] * dArray[n3 + 8] + (double)BASIS[n5 + 3] * dArray[n3 + 11]) / 6.0;
        }
        double d = 0.0;
        double d2 = 1.0 / (double)(n2 - 1);
        gL2.glBegin(3);
        for (int i = 0; i < n2; ++i) {
            double d3 = d * d;
            double d4 = d3 * d;
            double d5 = d4 * dArray2[0] + d3 * dArray2[3] + d * dArray2[6] + dArray2[9];
            double d6 = d4 * dArray2[1] + d3 * dArray2[4] + d * dArray2[7] + dArray2[10];
            double d7 = d4 * dArray2[2] + d3 * dArray2[5] + d * dArray2[8] + dArray2[11];
            gL2.glColor4d(d7 * (double)fArray[0] + (1.0 - d7) * (double)fArray2[0], d7 * (double)fArray[1] + (1.0 - d7) * (double)fArray2[1], d7 * (double)fArray[2] + (1.0 - d7) * (double)fArray2[2], (double)((float)this.getAlphaComponent()));
            gL2.glVertex3d(d5, d6, 0.0);
            d += d2;
        }
        gL2.glEnd();
    }

    public static class GLBundlingEdgeRendererConfiguration
    extends GLEdgeRenderer.GLEdgeRendererConfiguration {
        private double m_bundlingcoefficient = 0.75;

        public GLBundlingEdgeRendererConfiguration(String string) {
            super(string);
        }

        public double getBundlingCoefficient() {
            return this.m_bundlingcoefficient;
        }

        public GLBundlingEdgeRendererConfiguration setBundlingCoefficient(double d) {
            this.m_bundlingcoefficient = d;
            return this;
        }
    }
}

