/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.render;

import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.EnumSet;
import java.util.Set;
import javax.media.opengl.GL2;
import org.glowvis.data.Renderable;
import org.glowvis.vis.gl.render.GLNodeRenderer;
import org.glowvis.vis.text.GLTextRenderer;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class GLLabelRenderer
extends GLNodeRenderer {
    private GLTextRenderer m_renderer;

    public GLLabelRenderer(GLLabelRendererConfiguration gLLabelRendererConfiguration, GLTextRenderer gLTextRenderer) {
        super(gLLabelRendererConfiguration);
        this.m_renderer = gLTextRenderer;
    }

    public void render(GL2 gL2, VisualItem visualItem) {
        if (!this.isEnabled() || !this.isLabelRenderingEnabled(visualItem)) {
            return;
        }
        Renderable renderable = (Renderable)visualItem.get("glow.compoundgraph.itemref");
        String string = renderable.getLabel();
        float[] fArray = new float[3];
        this.getNodeColor().getColorComponents(fArray);
        gL2.glColor4f(fArray[0], fArray[1], fArray[2], 1.0f);
        this.m_renderer.render(gL2, visualItem.getX(), visualItem.getY(), string);
    }

    public boolean isLabelRenderingEnabled(VisualItem visualItem) {
        NodeItem nodeItem = (NodeItem)visualItem;
        boolean bl = !nodeItem.children().hasNext();
        return bl && this.getConfiguration().showLeafLabels() || !bl && this.getConfiguration().showNodeLabels();
    }

    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        return false;
    }

    public void setBounds(VisualItem visualItem) {
    }

    public Font getFont() {
        return this.getConfiguration().getFont();
    }

    public GLLabelRendererConfiguration getConfiguration() {
        return (GLLabelRendererConfiguration)super.getConfiguration();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GLLabelRendererConfiguration
    extends GLNodeRenderer.GLNodeRendererConfiguration {
        private Font m_font = new Font("SansSerif", 0, 12);
        private LabelDisplayOption m_labeldisplayoption = LabelDisplayOption.ALL;

        public GLLabelRendererConfiguration(String string) {
            super(string);
        }

        public Font getFont() {
            return this.m_font;
        }

        public GLLabelRendererConfiguration setFont(Font font) {
            this.m_font = font;
            return this;
        }

        public LabelDisplayOption getLabelDisplay() {
            return this.m_labeldisplayoption;
        }

        public GLLabelRendererConfiguration setLabelDisplayOption(LabelDisplayOption labelDisplayOption) {
            this.m_labeldisplayoption = labelDisplayOption;
            return this;
        }

        public boolean showNodeLabels() {
            return this.getLabelDisplay().showNodeLabels();
        }

        public boolean showLeafLabels() {
            return this.getLabelDisplay().showLeafLabels();
        }

        public Set<LabelDisplayOption> generateLabelDisplayOptions() {
            return EnumSet.of(LabelDisplayOption.NONE, LabelDisplayOption.NODES, LabelDisplayOption.LEAVES, LabelDisplayOption.ALL);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum LabelDisplayOption {
            NONE("No labels", NodeLabelDisplayOptions.HIDE, LeafLabelDisplayOptions.HIDE),
            NODES("Nodes only", NodeLabelDisplayOptions.SHOW, LeafLabelDisplayOptions.HIDE),
            LEAVES("Leaves only", NodeLabelDisplayOptions.HIDE, LeafLabelDisplayOptions.SHOW),
            ALL("All labels", NodeLabelDisplayOptions.SHOW, LeafLabelDisplayOptions.SHOW);

            private final String m_name;
            private final NodeLabelDisplayOptions m_nodes;
            private final LeafLabelDisplayOptions m_leaves;

            private LabelDisplayOption(String string2, NodeLabelDisplayOptions nodeLabelDisplayOptions, LeafLabelDisplayOptions leafLabelDisplayOptions) {
                this.m_name = string2;
                this.m_nodes = nodeLabelDisplayOptions;
                this.m_leaves = leafLabelDisplayOptions;
            }

            public String toString() {
                return this.m_name;
            }

            public boolean showNodeLabels() {
                return this.m_nodes == NodeLabelDisplayOptions.SHOW;
            }

            public boolean showLeafLabels() {
                return this.m_leaves == LeafLabelDisplayOptions.SHOW;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum LeafLabelDisplayOptions {
                SHOW,
                HIDE;

            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum NodeLabelDisplayOptions {
                SHOW,
                HIDE;

            }
        }
    }
}

