/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.render;

import com.sun.opengl.util.BufferUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL2;
import org.glowvis.vis.gl.render.GLBufferRenderer;
import org.glowvis.vis.gl.render.GLLabelRenderer;
import org.glowvis.vis.gl.render.GLNodeRenderer;
import org.glowvis.vis.gl.render.buffer.GLRenderBuffer;
import org.glowvis.vis.shape.RingSegment;
import org.glowvis.vis.text.GLTextRenderer;
import prefuse.visual.VisualItem;

public class GLRingSegmentRenderer
extends GLNodeRenderer {
    private int m_texture = -1;
    private GLLabelRenderer m_labelrenderer;

    public GLRingSegmentRenderer(GLNodeRenderer.GLNodeRendererConfiguration gLNodeRendererConfiguration, GLLabelRenderer.GLLabelRendererConfiguration gLLabelRendererConfiguration, GLTextRenderer gLTextRenderer) {
        super(gLNodeRendererConfiguration);
        this.m_labelrenderer = new GLLabelRenderer(gLLabelRendererConfiguration, gLTextRenderer);
    }

    public void render(GL2 gL2, VisualItem visualItem) {
        if (this.isEnabled()) {
            RingSegment ringSegment = this.getRingSegment(visualItem);
            this.renderRingSegment(gL2, ringSegment);
        }
        this.m_labelrenderer.render(gL2, visualItem);
    }

    public void renderRingSegment(GL2 gL2, RingSegment ringSegment) {
        GLBufferRenderer gLBufferRenderer = this.getBufferRenderer();
        int n = this.genTexture(gL2);
        float[] fArray = new float[3];
        this.getNodeColor().getColorComponents(fArray);
        gL2.glColor4f(fArray[0], fArray[1], fArray[2], 0.7f);
        gL2.glPolygonMode(1032, 6914);
        gL2.glEnable(3553);
        gL2.glBindTexture(3553, n);
        GLRenderBuffer gLRenderBuffer = ringSegment.getShapeBuffer();
        gLBufferRenderer.addBuffer(gLRenderBuffer, gL2);
        gLBufferRenderer.flushBuffers(gL2, 5, 0, gLRenderBuffer.getNumberOfVertices());
        gL2.glDisable(3553);
        gL2.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glPolygonMode(1032, 6914);
        GLRenderBuffer gLRenderBuffer2 = ringSegment.getOutlineBuffer();
        gLBufferRenderer.addBuffer(gLRenderBuffer2, gL2);
        gLBufferRenderer.flushBuffers(gL2, 2, 0, gLRenderBuffer2.getNumberOfVertices());
    }

    public void renderBoundingBox(GL2 gL2, RingSegment ringSegment) {
        Rectangle2D rectangle2D = ringSegment.getBounds();
        gL2.glColor4f(0.0f, 1.0f, 0.0f, 0.5f);
        gL2.glBegin(2);
        gL2.glVertex2f((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY());
        gL2.glVertex2f((float)rectangle2D.getMaxX(), (float)rectangle2D.getMinY());
        gL2.glVertex2f((float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY());
        gL2.glVertex2f((float)rectangle2D.getMinX(), (float)rectangle2D.getMaxY());
        gL2.glEnd();
    }

    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        return false;
    }

    public void setBounds(VisualItem visualItem) {
        RingSegment ringSegment = this.getRingSegment(visualItem);
        Rectangle2D rectangle2D = ringSegment.getBounds();
        visualItem.setBounds(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private RingSegment getRingSegment(VisualItem visualItem) {
        if (!visualItem.canGet("_arcrenderdata", RingSegment.class)) {
            throw new UnsupportedOperationException("Item does not contain arc render data.");
        }
        return (RingSegment)visualItem.get("_arcrenderdata");
    }

    private int genTexture(GL2 gL2) {
        if (this.m_texture != -1) {
            return this.m_texture;
        }
        BufferedImage bufferedImage = this.tempGenImage();
        ByteBuffer byteBuffer = this.tempGenByteBuffer(bufferedImage);
        int[] nArray = new int[1];
        gL2.glGenTextures(1, nArray, 0);
        this.m_texture = nArray[0];
        gL2.glBindTexture(3553, this.m_texture);
        gL2.glTexImage2D(3553, 0, 6407, bufferedImage.getWidth(), bufferedImage.getHeight(), 1, 6407, 5121, (Buffer)byteBuffer);
        gL2.glTexParameteri(3553, 10241, 9729);
        gL2.glTexParameteri(3553, 10240, 9729);
        return this.m_texture;
    }

    private BufferedImage tempGenImage() {
        int n = 128;
        int n2 = 32;
        boolean bl = false;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(n, 0.0);
        GradientPaint gradientPaint = new GradientPaint(double_, new Color(0.7f, 0.7f, 1.0f), double_2, Color.white);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, n, n2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.setStroke(new BasicStroke((float)bl));
        graphics2D.fill(double_3);
        return bufferedImage;
    }

    private ByteBuffer tempGenByteBuffer(BufferedImage bufferedImage) {
        int[] nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        int n = 3;
        byte[] byArray = new byte[n * nArray.length];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            byArray[n2++] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray[n2++] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[n2++] = (byte)(nArray[i] & 0xFF);
        }
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }
}

