/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.render.buffer;

import javax.media.opengl.GL2;
import org.glowvis.vis.gl.render.GLBufferRenderStrategy;
import org.glowvis.vis.gl.render.GLBufferRenderer;
import org.glowvis.vis.gl.render.buffer.GLRenderBuffer;

public interface GLInterleavedRenderBuffer
extends GLRenderBuffer {
    public int getVertexFormat();

    public static class Float
    extends GLRenderBuffer.Float
    implements GLInterleavedRenderBuffer {
        private int m_vertexformat;

        public Float(float[] fArray, int n) {
            this(fArray, n, 0);
        }

        public Float(float[] fArray, int n, int n2) {
            super(fArray, n2);
            this.m_vertexformat = n;
        }

        public int getVertexFormat() {
            return this.m_vertexformat;
        }

        public void acceptRenderer(GLBufferRenderer gLBufferRenderer, GL2 gL2) {
            gLBufferRenderer.setup(this, gL2);
        }

        public void setupRenderStrategy(GLBufferRenderStrategy gLBufferRenderStrategy, GL2 gL2) {
            gLBufferRenderStrategy.setup(this, gL2);
        }

        protected int getEntriesPerVertex() {
            switch (this.getVertexFormat()) {
                case 10784: {
                    return 2;
                }
                case 10785: {
                    return 3;
                }
                case 10791: {
                    return 5;
                }
                case 10788: 
                case 10789: {
                    return 6;
                }
                case 10792: 
                case 10794: 
                case 10795: {
                    return 8;
                }
                case 10790: {
                    return 10;
                }
                case 10796: {
                    return 12;
                }
                case 10797: {
                    return 15;
                }
            }
            throw new RuntimeException("Unsupported vertex format.");
        }
    }
}

