/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.gl.render.buffer;

import com.sun.opengl.util.BufferUtil;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;
import org.glowvis.vis.gl.render.GLBufferRenderStrategy;
import org.glowvis.vis.gl.render.GLBufferRenderer;

public interface GLRenderBuffer {
    public int getNumberOfVertices();

    public int getDataType();

    public int getStride();

    public Buffer getData();

    public void acceptRenderer(GLBufferRenderer var1, GL2 var2);

    public void setupRenderStrategy(GLBufferRenderStrategy var1, GL2 var2);

    public static abstract class Double
    extends AbstractBase {
        public Double(double[] dArray, int n) {
            super(n);
            this.m_buffer = this.constructBuffer(dArray);
        }

        public int getDataType() {
            return 5130;
        }

        private Buffer constructBuffer(double[] dArray) {
            DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer((int)dArray.length);
            doubleBuffer.put(dArray);
            return doubleBuffer.flip();
        }
    }

    public static abstract class Float
    extends AbstractBase {
        public Float(float[] fArray, int n) {
            super(n);
            this.m_buffer = this.constructBuffer(fArray);
        }

        public int getDataType() {
            return 5126;
        }

        private Buffer constructBuffer(float[] fArray) {
            FloatBuffer floatBuffer = BufferUtil.newFloatBuffer((int)fArray.length);
            floatBuffer.put(fArray);
            return floatBuffer.flip();
        }
    }

    public static abstract class AbstractBase
    implements GLRenderBuffer {
        protected Buffer m_buffer;
        private int m_stride;

        public AbstractBase(int n) {
            this.m_stride = n;
        }

        public int getNumberOfVertices() {
            return this.getBufferCapacity() / this.getEntriesPerVertex();
        }

        public int getStride() {
            return this.m_stride;
        }

        public Buffer getData() {
            return this.m_buffer;
        }

        private int getBufferCapacity() {
            return this.getData().capacity();
        }

        protected abstract int getEntriesPerVertex();
    }
}

