/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.layout;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import prefuse.action.layout.Layout;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.VisualTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundGraphLayout
extends Layout {
    private String m_inclusions_group;
    private NodeTransformPolicy m_policy;
    public static final String EDGEPARAM_CONTROLPOLYGON = "_controlpolygon";
    private static final Schema EDGEPARAMS = new Schema();

    public CompoundGraphLayout(String string, String string2) {
        this(string, string2, new NodeCopyCoordinatesPolicy());
    }

    public CompoundGraphLayout(String string, String string2, NodeTransformPolicy nodeTransformPolicy) {
        super(string2);
        this.m_inclusions_group = string;
        this.m_policy = nodeTransformPolicy;
    }

    public void run(double d) {
        VisualTree visualTree = (VisualTree)this.m_vis.getGroup(this.m_inclusions_group);
        VisualTable visualTable = (VisualTable)visualTree.getNodes();
        VisualGraph visualGraph = (VisualGraph)this.m_vis.getGroup(this.m_group);
        VisualTable visualTable2 = (VisualTable)visualGraph.getNodes();
        VisualTable visualTable3 = (VisualTable)visualGraph.getEdges();
        this.initializeSchemas((TupleSet)visualTable2, (TupleSet)visualTable3);
        this.initNodes(visualTable2, visualTable, this.m_policy);
        this.initEdges(visualTable, visualTable2, visualTable3);
    }

    private int initNodes(VisualTable visualTable, VisualTable visualTable2, NodeTransformPolicy nodeTransformPolicy) {
        int n;
        assert (visualTable2.getRowCount() == visualTable.getRowCount());
        for (n = 0; n < visualTable2.getRowCount(); ++n) {
            NodeItem nodeItem = (NodeItem)visualTable2.getItem(n);
            NodeItem nodeItem2 = (NodeItem)visualTable.getItem(n);
            nodeTransformPolicy.transform(nodeItem, nodeItem2);
        }
        return n;
    }

    private int initEdges(VisualTable visualTable, VisualTable visualTable2, VisualTable visualTable3) {
        int n;
        for (n = 0; n < visualTable3.getRowCount(); ++n) {
            EdgeItem edgeItem = (EdgeItem)visualTable3.getItem(n);
            List<VisualItem> list = this.createControlPolygon(edgeItem, visualTable, visualTable2);
            this.setControlPolygon(edgeItem, list);
        }
        return n;
    }

    private List<VisualItem> createControlPolygon(EdgeItem edgeItem, VisualTable visualTable, VisualTable visualTable2) {
        ArrayList<VisualItem> arrayList = new ArrayList<VisualItem>();
        NodeItem nodeItem = edgeItem.getSourceItem();
        NodeItem nodeItem2 = edgeItem.getTargetItem();
        NodeItem nodeItem3 = (NodeItem)visualTable.getItem(nodeItem.getRow());
        NodeItem nodeItem4 = (NodeItem)visualTable.getItem(nodeItem2.getRow());
        List<Node> list = this.getInclusionPath((Node)nodeItem3, (Node)nodeItem4);
        arrayList.add((VisualItem)nodeItem3);
        for (Node node : list) {
            VisualItem visualItem = visualTable2.getItem(node.getRow());
            arrayList.add(visualItem);
        }
        arrayList.add((VisualItem)nodeItem4);
        return arrayList;
    }

    private void setControlPolygon(EdgeItem edgeItem, List<VisualItem> list) {
        edgeItem.set(EDGEPARAM_CONTROLPOLYGON, list);
    }

    private List<Node> getInclusionPath(Node node, Node node2) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        while (node != null) {
            linkedList.addLast(node);
            node = node.getParent();
        }
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        while (node2 != null) {
            linkedList2.addFirst(node2);
            node2 = node2.getParent();
        }
        Node node3 = (Node)linkedList.getLast();
        while (linkedList.size() > 0 && linkedList2.size() > 0 && ((Node)linkedList.getLast()).equals(linkedList2.getFirst())) {
            node3 = linkedList.removeLast();
            linkedList2.removeFirst();
        }
        linkedList.addLast(node3);
        linkedList.addAll(linkedList2);
        return linkedList;
    }

    private void initializeSchemas(TupleSet tupleSet, TupleSet tupleSet2) {
        tupleSet2.addColumns(EDGEPARAMS);
    }

    static {
        EDGEPARAMS.addColumn(EDGEPARAM_CONTROLPOLYGON, List.class, null);
    }

    public static class NodeCopyCoordinatesPolicy
    implements NodeTransformPolicy {
        public void transform(NodeItem nodeItem, NodeItem nodeItem2) {
            nodeItem2.setX(nodeItem.getX());
            nodeItem2.setY(nodeItem.getY());
        }
    }

    public static interface NodeTransformPolicy {
        public void transform(NodeItem var1, NodeItem var2);
    }
}

