/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.layout;

import java.util.Iterator;
import java.util.List;
import org.glowvis.vis.layout.CompoundGraphLayout;
import org.glowvis.vis.math.AngularRange;
import org.glowvis.vis.math.Vector2;
import org.glowvis.vis.shape.RadialBox;
import org.glowvis.vis.shape.RingSegment;
import prefuse.Visualization;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Schema;
import prefuse.data.Tree;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.NodeItem;

public class InvertedRadialTreeLayout
extends TreeLayout {
    private int m_treedepth = -1;
    private List<Vector2> m_interpolations;
    private AngularRange m_angular_range;
    private static final AngularRange DEFAULT_ANGULAR_RANGE = new AngularRange(0.0, Math.PI * 2);
    private double m_radius_increment;
    private static final double DEFAULT_RADIUS_INCREMENT = 10.0;
    public static final String NODEPARAM_RADIALBOX = "_radialbox";
    public static final String NODEPARAM_LEAFCOUNT = "_leafcount";
    private static final Schema NODEPARAMS = new Schema();

    public InvertedRadialTreeLayout(String string) {
        this(string, DEFAULT_ANGULAR_RANGE, 10.0);
    }

    public InvertedRadialTreeLayout(String string, AngularRange angularRange) {
        this(string, angularRange, 10.0);
    }

    public InvertedRadialTreeLayout(String string, double d) {
        this(string, DEFAULT_ANGULAR_RANGE, d);
    }

    public InvertedRadialTreeLayout(String string, AngularRange angularRange, double d) {
        super(string);
        this.m_angular_range = angularRange;
        this.m_radius_increment = d;
    }

    public void run(double d) {
        Visualization visualization = this.getVisualization();
        Tree tree = (Tree)visualization.getGroup(this.getGroup());
        this.initializeSchemas(tree.getNodes(), tree.getEdges());
        NodeItem nodeItem = this.getLayoutRoot();
        this.m_treedepth = this.processSubtree(nodeItem);
        this.m_interpolations = this.getRange().interpolate(2 * this.getLeafCount(nodeItem) + 1);
        this.setRenderData(nodeItem, 0);
    }

    public AngularRange getRange() {
        return this.m_angular_range;
    }

    public int getTreeDepth() {
        return this.m_treedepth;
    }

    public int getRing(NodeItem nodeItem) {
        return 2 * (this.m_treedepth - 1) - nodeItem.getDepth();
    }

    public double getInnerRadius(NodeItem nodeItem) {
        return (double)this.getRing(nodeItem) * this.m_radius_increment;
    }

    public double getOuterRadius(NodeItem nodeItem) {
        return this.getInnerRadius(nodeItem) + this.m_radius_increment;
    }

    public int getLeafCount(NodeItem nodeItem) {
        return nodeItem.getInt(NODEPARAM_LEAFCOUNT);
    }

    public CompoundGraphLayout.NodeTransformPolicy getNodeTransformPolicy() {
        return new CompoundGraphLayout.NodeTransformPolicy(){

            public void transform(NodeItem nodeItem, NodeItem nodeItem2) {
                assert (InvertedRadialTreeLayout.this.m_treedepth >= 1);
                double d = (double)(InvertedRadialTreeLayout.this.m_treedepth - 1) * InvertedRadialTreeLayout.this.m_radius_increment;
                Vector2 vector2 = new Vector2(nodeItem.getX(), nodeItem.getY());
                double d2 = 2.0 * d / vector2.getLength() - 1.0;
                nodeItem2.setX(nodeItem.getX() * d2);
                nodeItem2.setY(nodeItem.getY() * d2);
            }
        };
    }

    private int processSubtree(NodeItem nodeItem) {
        int n = 0;
        int n2 = 0;
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            n = Math.max(n, this.processSubtree(nodeItem2));
            n2 += this.getLeafCount(nodeItem2);
        }
        n2 = Math.max(1, n2);
        this.setLeafCount(nodeItem, n2);
        return n + 1;
    }

    private void setRenderData(NodeItem nodeItem, int n) {
        int n2 = n;
        int n3 = n2 + this.getLeafCount(nodeItem) * 2;
        AngularRange angularRange = new AngularRange(this.m_interpolations.get(n2), this.m_interpolations.get(n3));
        RadialBox radialBox = new RadialBox(this.getInnerRadius(nodeItem), this.getOuterRadius(nodeItem), angularRange);
        this.setRadialBox(nodeItem, radialBox);
        double d = angularRange.getV1().getAngle();
        double d2 = angularRange.getV2().getAngle();
        d2 = d2 > d ? d2 : d2 + Math.PI * 2;
        nodeItem.set("_arcrenderdata", (Object)new RingSegment(d, d2, radialBox.getInnerRadius(), radialBox.getOuterRadius()));
        int n4 = n2 + this.getLeafCount(nodeItem);
        Vector2 vector2 = this.m_interpolations.get(n4);
        nodeItem.setX(vector2.getX() * this.getInnerRadius(nodeItem));
        nodeItem.setY(vector2.getY() * this.getInnerRadius(nodeItem));
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            this.setRenderData(nodeItem2, n);
            n += 2 * this.getLeafCount(nodeItem2);
        }
    }

    private void setLeafCount(NodeItem nodeItem, int n) {
        nodeItem.setInt(NODEPARAM_LEAFCOUNT, n);
    }

    private void setRadialBox(NodeItem nodeItem, RadialBox radialBox) {
        nodeItem.set(NODEPARAM_RADIALBOX, (Object)radialBox);
    }

    private void initializeSchemas(TupleSet tupleSet, TupleSet tupleSet2) {
        tupleSet.addColumns(NODEPARAMS);
    }

    static {
        NODEPARAMS.addColumn(NODEPARAM_RADIALBOX, RadialBox.class, null);
        NODEPARAMS.addColumn(NODEPARAM_LEAFCOUNT, Integer.TYPE, (Object)0);
        NODEPARAMS.addColumn("_arcrenderdata", RingSegment.class, null);
    }
}

