/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.layout;

import java.awt.geom.Point2D;
import java.util.Iterator;
import org.glowvis.vis.shape.RingSegment;
import prefuse.Visualization;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTree;

public class ShellTreeLayout
extends TreeLayout {
    private VisualTree m_tree;
    private int m_treedepth = 0;
    private double m_unitwidthsize = 0.0;
    private double m_innerradius = 100.0;
    private double m_archeight = 20.0;
    private static final double DEFAULT_INNERRADIUS = 100.0;
    private static final double DEFAULT_ARCHEIGHT = 20.0;
    private static final String PARAM_ARCUNITWIDTH = "_arcunitwidth";
    private static final Schema SCHEMA = new Schema();

    public ShellTreeLayout(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(double d) {
        Visualization visualization = this.m_vis;
        synchronized (visualization) {
            ShellTreeLayout shellTreeLayout = this;
            synchronized (shellTreeLayout) {
                this.initialize();
                if (this.m_treedepth <= 0) {
                    return;
                }
                NodeItem nodeItem = this.getLayoutRoot();
                this.layoutSubtree(nodeItem, 0.0);
            }
        }
    }

    private void initialize() {
        this.m_tree = (VisualTree)this.m_vis.getGroup(this.m_group);
        this.addLayoutSchema();
        this.processTree();
    }

    private void layoutSubtree(NodeItem nodeItem, double d) {
        double d2 = this.getNodeWidth(nodeItem);
        double d3 = d;
        double d4 = d3 + d2;
        double d5 = this.getNodeDistance(nodeItem);
        double d6 = d5 + this.getNodeHeight(nodeItem);
        double d7 = (d4 + d3) / 2.0;
        Point2D point2D = this.polarToCartesian(d7, d5);
        this.setX((VisualItem)nodeItem, null, point2D.getX());
        this.setY((VisualItem)nodeItem, null, point2D.getY());
        nodeItem.set("_arcrenderdata", (Object)new RingSegment(d3, d4, d5, d6));
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            double d8 = this.getNodeWidth(nodeItem2);
            this.layoutSubtree(nodeItem2, d3);
            d3 += d8;
        }
    }

    private int getNodeLayer(NodeItem nodeItem) {
        if (nodeItem.getChildCount() >= 0) {
            return this.m_treedepth - nodeItem.getDepth() - 1;
        }
        return 0;
    }

    private double getNodeWidth(NodeItem nodeItem) {
        return this.m_unitwidthsize * (double)nodeItem.getInt(PARAM_ARCUNITWIDTH);
    }

    private double getNodeDistance(NodeItem nodeItem) {
        return this.m_innerradius + this.m_archeight * (double)this.getNodeLayer(nodeItem);
    }

    private double getNodeHeight(NodeItem nodeItem) {
        return this.m_archeight;
    }

    private void processTree() {
        NodeItem nodeItem = this.getLayoutRoot();
        if (nodeItem == null) {
            return;
        }
        this.m_treedepth = this.processSubtree(nodeItem);
        int n = nodeItem.getInt(PARAM_ARCUNITWIDTH);
        this.m_unitwidthsize = Math.PI * 2 / (double)n;
    }

    private int processSubtree(NodeItem nodeItem) {
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.m_tree.children((Node)nodeItem);
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            n = Math.max(n, this.processSubtree(nodeItem2));
            n2 += nodeItem2.getInt(PARAM_ARCUNITWIDTH);
        }
        n2 = Math.max(1, n2);
        nodeItem.setInt(PARAM_ARCUNITWIDTH, n2);
        return n + 1;
    }

    private Point2D polarToCartesian(double d, double d2) {
        return new Point2D.Double(d2 * Math.cos(d), d2 * Math.sin(d));
    }

    private void addLayoutSchema() {
        this.m_tree.getNodes().addColumns(SCHEMA);
    }

    static {
        SCHEMA.addColumn(PARAM_ARCUNITWIDTH, Integer.TYPE);
        SCHEMA.addColumn("_arcrenderdata", RingSegment.class);
    }
}

