/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.math;

import java.util.ArrayList;
import java.util.List;
import org.glowvis.vis.math.Vector2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AngularRange
implements Cloneable {
    private Vector2 m_v1;
    private Vector2 m_v2;

    public AngularRange(double d, double d2) {
        this(new Vector2(d), new Vector2(d2));
    }

    public AngularRange(Vector2 vector2, Vector2 vector22) {
        this.m_v1 = vector2;
        this.m_v2 = vector22;
    }

    public Vector2 getV1() {
        return this.m_v1;
    }

    public Vector2 getV2() {
        return this.m_v2;
    }

    public double getAngularWidth() {
        double d = Math.acos(Vector2.dot(this.getV1(), this.getV2()));
        return d != 0.0 ? d : (this.getV1().equals(this.getV2()) ? 0.0 : Math.PI * 2);
    }

    public boolean contains(double d) {
        return this.contains(new Vector2(d));
    }

    public boolean contains(Vector2 vector2) {
        return vector2.isBetween(this.m_v1, this.m_v2);
    }

    public List<Vector2> interpolate(int n) {
        assert (n >= 2);
        ArrayList<Vector2> arrayList = new ArrayList<Vector2>(n);
        arrayList.add(this.getV1());
        if (n > 2) {
            double d = this.getAngularWidth() / (double)(n - 1);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            for (int i = 1; i < n - 1; ++i) {
                Vector2 vector2 = arrayList.get(i - 1);
                Vector2 vector22 = new Vector2(vector2.getX() * d2 - vector2.getY() * d3, vector2.getX() * d3 + vector2.getY() * d2);
                arrayList.add(vector22);
            }
        }
        arrayList.add(this.getV2());
        return arrayList;
    }
}

