/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.math;

public class TrigonometryLookup {
    private static final int s_lookup_precision_bits = 8;
    private static final TrigonometryLookup s_lookup = new TrigonometryLookup(8);
    private int m_mask;
    private double m_ratio;
    private double[] m_sin;
    private double[] m_cos;

    public static TrigonometryLookup getLookup() {
        return s_lookup;
    }

    private TrigonometryLookup(int n) {
        int n2 = 1 << n;
        this.m_mask = n2 - 1;
        this.m_ratio = (double)n2 / (Math.PI * 2);
        this.m_sin = new double[n2];
        this.m_cos = new double[n2];
        double d = 0.0;
        double d2 = Math.PI * 2 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            this.m_sin[i] = Math.sin(d);
            this.m_cos[i] = Math.cos(d);
            d += d2;
        }
    }

    public double getSin(int n) {
        return this.m_sin[n & this.m_mask];
    }

    public double getCos(int n) {
        return this.m_cos[n & this.m_mask];
    }

    public int getPrecision() {
        return this.m_mask + 1;
    }

    public double getRatio() {
        return this.m_ratio;
    }

    public int getIndexLowerBound(double d) {
        int n = (int)Math.floor(this.getFractionalIndex(d));
        return n & this.m_mask;
    }

    public int getIndexUpperBound(double d) {
        int n = (int)Math.ceil(this.getFractionalIndex(d));
        return n & this.m_mask;
    }

    private double getFractionalIndex(double d) {
        return d * this.m_ratio;
    }

    public int clampFraction(double d) {
        int n = (int)((double)this.getPrecision() * d + 0.5);
        return n & this.m_mask;
    }
}

