/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.math;

public class Vector2
implements Cloneable {
    private double m_x;
    private double m_y;

    public Vector2(double d, double d2) {
        this.m_x = d;
        this.m_y = d2;
    }

    public Vector2(double d) {
        this(Math.cos(d), Math.sin(d));
    }

    public double getX() {
        return this.m_x;
    }

    public double getY() {
        return this.m_y;
    }

    public double getAngle() {
        return Math.atan2(this.getY(), this.getX());
    }

    public double getLength() {
        return Math.sqrt(this.getLengthSquared());
    }

    public double getLengthSquared() {
        return Vector2.dot(this, this);
    }

    public Vector2 asUnitVector() {
        double d = this.getLength();
        return new Vector2(this.getX() / d, this.getY() / d);
    }

    public static double dot(Vector2 vector2, Vector2 vector22) {
        return vector2.getX() * vector22.getX() + vector2.getY() * vector22.getY();
    }

    public static double cpsm(Vector2 vector2, Vector2 vector22) {
        return vector2.getX() * vector22.getY() - vector2.getY() * vector22.getX();
    }

    public boolean isBetween(Vector2 vector2, Vector2 vector22) {
        boolean bl = Vector2.cpsm(vector2, vector22) >= 0.0;
        boolean bl2 = Vector2.cpsm(vector2, this) >= 0.0;
        boolean bl3 = Vector2.cpsm(this, vector22) >= 0.0;
        return bl && bl2 && bl3 || !bl && (bl2 || bl3);
    }
}

