/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.shape;

import java.awt.geom.Rectangle2D;
import org.glowvis.vis.gl.render.buffer.GLInterleavedRenderBuffer;
import org.glowvis.vis.gl.render.buffer.GLRenderBuffer;
import org.glowvis.vis.gl.render.buffer.GLVertexArrayRenderBuffer;
import org.glowvis.vis.math.TrigonometryLookup;

public class RingSegment
implements Cloneable {
    private double m_start_angle;
    private double m_end_angle;
    private double m_inner_radius;
    private double m_outer_radius;
    private Rectangle2D m_bounds;
    private GLRenderBuffer m_shape;
    private GLRenderBuffer m_outline;
    public static final String PARAM_ARCRENDERDATA = "_arcrenderdata";
    public static final int NOF_VERTEX_FIELDS = 5;
    public static final int VERTEX_COORD_OFFSET = 2;

    public RingSegment(double d, double d2, double d3, double d4) {
        this.m_start_angle = d;
        this.m_end_angle = d2;
        this.m_inner_radius = d3;
        this.m_outer_radius = d4;
        this.process();
    }

    public RingSegment(double d, double d2, double d3, double d4, Rectangle2D rectangle2D, GLRenderBuffer gLRenderBuffer, GLRenderBuffer gLRenderBuffer2) {
        this.m_start_angle = d;
        this.m_end_angle = d2;
        this.m_inner_radius = d3;
        this.m_outer_radius = d4;
        this.m_bounds = rectangle2D;
        this.m_shape = gLRenderBuffer;
        this.m_outline = gLRenderBuffer2;
    }

    public double getWidth() {
        return this.m_end_angle - this.m_start_angle;
    }

    public double getHeight() {
        return this.m_outer_radius - this.m_inner_radius;
    }

    public double getDistance() {
        return this.m_inner_radius;
    }

    public double getMinAngularExtent() {
        return this.m_start_angle;
    }

    public double getMaxAngularExtent() {
        return this.m_end_angle;
    }

    public double getInnerRadius() {
        return this.m_inner_radius;
    }

    public double getOuterRadius() {
        return this.m_outer_radius;
    }

    public Rectangle2D getBounds() {
        return this.m_bounds;
    }

    public GLRenderBuffer getShapeBuffer() {
        return this.m_shape;
    }

    public GLRenderBuffer getOutlineBuffer() {
        return this.m_outline;
    }

    private synchronized void process() {
        float[] fArray = this.generateVertexData();
        this.m_bounds = this.extractBounds(fArray);
        this.m_shape = new GLInterleavedRenderBuffer.Float(fArray, 10791);
        float[] fArray2 = this.generateOutlineLoop(fArray);
        this.m_outline = new GLVertexArrayRenderBuffer.Float(fArray2, 3);
    }

    public boolean isAngleInsideArc(double d) {
        return this.getMinAngularExtent() <= d && d <= this.getMaxAngularExtent();
    }

    private float[] generateVertexData() {
        double d = this.getMinAngularExtent();
        double d2 = this.getMaxAngularExtent();
        double d3 = this.getInnerRadius();
        double d4 = this.getOuterRadius();
        TrigonometryLookup trigonometryLookup = TrigonometryLookup.getLookup();
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        if ((d2 - d) * trigonometryLookup.getRatio() > 1.0) {
            n = trigonometryLookup.getIndexUpperBound(d);
            n2 = trigonometryLookup.getIndexLowerBound(d2);
            if (n2 < n) {
                n2 += trigonometryLookup.getPrecision();
            }
            n3 = n2 - n + 1;
        }
        int n4 = (n3 + 2) * 2;
        int n5 = n4 * 5;
        float[] fArray = new float[n5];
        int n6 = 0;
        float f = 1.0f / (float)(n3 + 1);
        float f2 = 0.0f;
        float f3 = (float)Math.sin(d);
        float f4 = (float)Math.cos(d);
        fArray[n6++] = 0.0f;
        fArray[n6++] = 0.0f;
        fArray[n6++] = (float)d3 * f4;
        fArray[n6++] = (float)d3 * f3;
        fArray[n6++] = 0.0f;
        fArray[n6++] = 0.0f;
        fArray[n6++] = 1.0f;
        fArray[n6++] = (float)d4 * f4;
        fArray[n6++] = (float)d4 * f3;
        fArray[n6++] = 0.0f;
        for (int i = n; i <= n2; ++i) {
            f3 = (float)trigonometryLookup.getSin(i);
            f4 = (float)trigonometryLookup.getCos(i);
            fArray[n6++] = f2 += f;
            fArray[n6++] = 0.0f;
            fArray[n6++] = (float)d3 * f4;
            fArray[n6++] = (float)d3 * f3;
            fArray[n6++] = 0.0f;
            fArray[n6++] = f2;
            fArray[n6++] = 1.0f;
            fArray[n6++] = (float)d4 * f4;
            fArray[n6++] = (float)d4 * f3;
            fArray[n6++] = 0.0f;
        }
        f3 = (float)Math.sin(d2);
        f4 = (float)Math.cos(d2);
        fArray[n6++] = 1.0f;
        fArray[n6++] = 0.0f;
        fArray[n6++] = (float)d3 * f4;
        fArray[n6++] = (float)d3 * f3;
        fArray[n6++] = 0.0f;
        fArray[n6++] = 1.0f;
        fArray[n6++] = 1.0f;
        fArray[n6++] = (float)d4 * f4;
        fArray[n6++] = (float)d4 * f3;
        fArray[n6++] = 0.0f;
        return fArray;
    }

    private float[] generateOutlineLoop(float[] fArray) {
        int n = fArray.length * 3 / 5;
        float[] fArray2 = new float[n];
        int n2 = 0;
        for (int i = 0; i < fArray.length; i += 10) {
            fArray2[n2] = fArray[2 + i];
            fArray2[n2 + 1] = fArray[2 + i + 1];
            fArray2[n2 + 2] = 0.0f;
            fArray2[n - n2 - 3] = fArray[7 + i];
            fArray2[n - n2 - 2] = fArray[7 + i + 1];
            fArray2[n - n2 - 1] = 0.0f;
            n2 += 3;
        }
        return fArray2;
    }

    private Rectangle2D extractBounds(float[] fArray) {
        Rectangle2D.Float float_;
        float f;
        float f2;
        int n = 2;
        if (fArray.length >= 5) {
            f2 = fArray[n];
            f = fArray[n + 1];
            n += 5;
            float_ = new Rectangle2D.Float(f2, f, 0.0f, 0.0f);
        } else {
            return null;
        }
        while (n < fArray.length) {
            f2 = fArray[n];
            f = fArray[n + 1];
            n += 5;
            float_.add(f2, f);
        }
        return float_;
    }

    public Object clone() {
        return new RingSegment(this.m_start_angle, this.m_end_angle, this.m_inner_radius, this.m_outer_radius, this.m_bounds, this.m_shape, this.m_outline);
    }
}

