/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.text;

import com.sun.opengl.util.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL2;
import org.glowvis.vis.text.Glyph;

public class GLGlyphCache {
    private List<Page> m_pages;
    private Map<Glyph, Block> m_glyphs;
    private int m_pagewidth;
    private int m_pageheight;
    private static final int BYTES_PER_PIXEL = 4;
    private static final int DEFAULT_PAGE_WIDTH = 512;
    private static final int DEFAULT_PAGE_HEIGHT = 512;

    public GLGlyphCache() {
        this(512, 512);
    }

    public GLGlyphCache(int n, int n2) {
        this.m_pagewidth = n;
        this.m_pageheight = n2;
        this.m_pages = new ArrayList<Page>();
        this.m_glyphs = new HashMap<Glyph, Block>();
    }

    public int getPageWidth() {
        return this.m_pagewidth;
    }

    public int getPageHeight() {
        return this.m_pageheight;
    }

    public void store(GL2 gL2, Glyph glyph) {
        if (this.m_glyphs.containsKey(glyph)) {
            return;
        }
        if (glyph.isWhitespace()) {
            return;
        }
        Glyph.Pixels pixels = glyph.renderPixels();
        Block block = this.allocate(gL2, pixels.getWidth(), pixels.getHeight());
        this.m_glyphs.put(glyph, block);
        int n = block.getPage().getTexId();
        gL2.glEnable(3553);
        gL2.glBindTexture(3553, n);
        gL2.glTexSubImage2D(3553, 0, block.getX(), block.getY(), pixels.getWidth(), pixels.getHeight(), 6408, 5121, (Buffer)pixels.getBuffer());
        gL2.glDisable(3553);
    }

    public void drawPage(GL2 gL2, int n) {
        if (n >= this.m_pages.size()) {
            return;
        }
        gL2.glEnable(3553);
        gL2.glBindTexture(3553, this.m_pages.get(n).getTexId());
        gL2.glColor3f(0.0f, 0.0f, 0.0f);
        gL2.glBegin(7);
        gL2.glTexCoord2d(0.0, 0.0);
        gL2.glVertex2d(100.0, 50.0);
        gL2.glTexCoord2d(1.0, 0.0);
        gL2.glVertex2d(100.0 + (double)this.getPageHeight(), 50.0);
        gL2.glTexCoord2d(1.0, 1.0);
        gL2.glVertex2d(100.0 + (double)this.getPageHeight(), 50.0 + (double)this.getPageWidth());
        gL2.glTexCoord2d(0.0, 1.0);
        gL2.glVertex2d(100.0, 50.0 + (double)this.getPageWidth());
        gL2.glEnd();
        gL2.glDisable(3553);
    }

    private Block allocate(GL2 gL2, int n, int n2) {
        if (n > this.getPageWidth() || n2 > this.getPageHeight()) {
            return null;
        }
        for (Page page : this.m_pages) {
            Block block = page.allocate(n, n2);
            if (block == null) continue;
            return block;
        }
        Page page = new Page(gL2);
        this.m_pages.add(page);
        return page.allocate(n, n2);
    }

    private class Page {
        private int m_texid;
        private int m_yoffset;
        private List<Line> m_lines;
        private static final float MIN_HEIGHT_RATIO = 0.7f;
        private static final float LINE_HEIGHT_MULTIPLIER = 1.1f;

        public Page(GL2 gL2) {
            this.m_texid = this.genTexture(gL2, GLGlyphCache.this.getPageWidth(), GLGlyphCache.this.getPageHeight());
            this.m_lines = new ArrayList<Line>();
            this.m_yoffset = 0;
        }

        public int getTexId() {
            return this.m_texid;
        }

        public int getRemainingHeight() {
            return GLGlyphCache.this.getPageHeight() - this.m_yoffset;
        }

        public Block allocate(int n, int n2) {
            float f = 0.0f;
            Line line = null;
            for (Line line2 : this.m_lines) {
                float f2;
                if (line2.getLineHeight() < n2 || line2.getRemainingWidth() < n || !((f2 = (float)n2 / (float)line2.getLineHeight()) > f)) continue;
                f = f2;
                line = line2;
            }
            if (line != null && f > 0.7f) {
                return line.allocate(n, n2);
            }
            int n3 = (int)((float)n2 * 1.1f);
            if (this.getRemainingHeight() < n3) {
                return null;
            }
            return this.newLine(n3).allocate(n, n2);
        }

        private Line newLine(int n) {
            assert (this.getRemainingHeight() >= n);
            Line line = new Line(this.m_yoffset, n);
            this.m_lines.add(line);
            this.m_yoffset += n;
            return line;
        }

        private int genTexture(GL2 gL2, int n, int n2) {
            int[] nArray = new int[1];
            gL2.glEnable(3553);
            gL2.glGenTextures(1, nArray, 0);
            gL2.glBindTexture(3553, nArray[0]);
            gL2.glTexParameteri(3553, 10241, 9728);
            gL2.glTexParameteri(3553, 10240, 9728);
            int n3 = n * n2 * 4;
            ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)n3);
            byteBuffer.put(new byte[n3]).flip();
            gL2.glTexImage2D(3553, 0, 4, n, n2, 0, 6408, 5121, (Buffer)byteBuffer);
            gL2.glDisable(3553);
            return nArray[0];
        }

        private class Line {
            private int m_y;
            private int m_lineheight;
            private int m_xoffset;

            public Line(int n, int n2) {
                this.m_y = n;
                this.m_lineheight = n2;
                this.m_xoffset = 0;
            }

            public int getLineHeight() {
                return this.m_lineheight;
            }

            public int getRemainingWidth() {
                return GLGlyphCache.this.getPageWidth() - this.m_xoffset;
            }

            public Block allocate(int n, int n2) {
                if (this.getRemainingWidth() < n) {
                    return null;
                }
                Block block = new Block(Page.this, this.m_xoffset, this.m_y, n, n2);
                this.m_xoffset += n;
                return block;
            }
        }
    }

    private class Block {
        private Page m_page;
        private int m_x;
        private int m_y;
        private int m_w;
        private int m_h;

        public Block(Page page, int n, int n2, int n3, int n4) {
            this.m_page = page;
            this.m_x = n;
            this.m_y = n2;
            this.m_w = n3;
            this.m_h = n4;
        }

        public Page getPage() {
            return this.m_page;
        }

        public int getX() {
            return this.m_x;
        }

        public int getY() {
            return this.m_y;
        }

        public int getWidth() {
            return this.m_w;
        }

        public int getHeight() {
            return this.m_h;
        }
    }
}

