/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.text;

import com.sun.opengl.util.BufferUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL2;
import org.glowvis.vis.gl.GLDisplay;

public class GLTextRenderer {
    private GLDisplay m_display;
    private Font m_font;
    private Map<String, LabelTexture> m_labelstore;

    public GLTextRenderer(GLDisplay gLDisplay, Font font) {
        this.m_display = gLDisplay;
        this.m_font = font;
        this.m_labelstore = new HashMap<String, LabelTexture>();
    }

    public void render(GL2 gL2, double d, double d2, String string) {
        LabelTexture labelTexture = this.getLabelTexture(gL2, string);
        double[] dArray = new double[]{d, d2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] dArray2 = new double[10];
        this.m_display.getTransform().transform(dArray, 0, dArray2, 0, 1);
        dArray2[2] = dArray2[0] - (double)labelTexture.getWidth() * 0.5;
        dArray2[3] = dArray2[1] - (double)labelTexture.getHeight() * 0.5;
        dArray2[4] = dArray2[0] + (double)labelTexture.getWidth() * 0.5;
        dArray2[5] = dArray2[1] - (double)labelTexture.getHeight() * 0.5;
        dArray2[6] = dArray2[0] + (double)labelTexture.getWidth() * 0.5;
        dArray2[7] = dArray2[1] + (double)labelTexture.getHeight() * 0.5;
        dArray2[8] = dArray2[0] - (double)labelTexture.getWidth() * 0.5;
        dArray2[9] = dArray2[1] + (double)labelTexture.getHeight() * 0.5;
        this.m_display.getInverseTransform().transform(dArray2, 2, dArray, 2, 4);
        gL2.glEnable(3553);
        gL2.glBindTexture(3553, labelTexture.getTexId());
        gL2.glBegin(7);
        gL2.glTexCoord2d(0.0, 0.0);
        gL2.glVertex3d(dArray[2], dArray[3], 1.0);
        gL2.glTexCoord2d(1.0, 0.0);
        gL2.glVertex3d(dArray[4], dArray[5], 1.0);
        gL2.glTexCoord2d(1.0, 1.0);
        gL2.glVertex3d(dArray[6], dArray[7], 1.0);
        gL2.glTexCoord2d(0.0, 1.0);
        gL2.glVertex3d(dArray[8], dArray[9], 1.0);
        gL2.glEnd();
        gL2.glDisable(3553);
    }

    private LabelTexture getLabelTexture(GL2 gL2, String string) {
        if (!this.m_labelstore.containsKey(string)) {
            this.m_labelstore.put(string, new LabelTexture(gL2, string));
        }
        return this.m_labelstore.get(string);
    }

    private class LabelTexture {
        private int m_texid;
        private int m_width;
        private int m_height;

        public LabelTexture(GL2 gL2, String string) {
            BufferedImage bufferedImage = this.createLabelBuffer(string);
            this.m_texid = this.storeLabelTexture(gL2, bufferedImage);
            this.m_width = bufferedImage.getWidth();
            this.m_height = bufferedImage.getHeight();
        }

        public int getTexId() {
            return this.m_texid;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }

        private BufferedImage createLabelBuffer(String string) {
            FontRenderContext fontRenderContext = ((Graphics2D)GLTextRenderer.this.m_display.getGraphics()).getFontRenderContext();
            TextLayout textLayout = new TextLayout(string, GLTextRenderer.this.m_font, fontRenderContext);
            Rectangle rectangle = new Rectangle(40, 20);
            rectangle.height += 20;
            Rectangle rectangle2 = this.calcTexBounds(rectangle);
            BufferedImage bufferedImage = new BufferedImage((int)rectangle2.getWidth(), (int)rectangle2.getHeight(), 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setPaint(Color.WHITE);
            double d = (rectangle2.getWidth() - rectangle.getWidth()) * 0.5;
            double d2 = (rectangle2.getHeight() - rectangle.getHeight()) * 0.5;
            textLayout.draw(graphics2D, (float)d, (float)(d2 + (double)textLayout.getAscent()));
            return bufferedImage;
        }

        private int storeLabelTexture(GL2 gL2, BufferedImage bufferedImage) {
            int[] nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
            int n = 4;
            int n2 = 0;
            byte[] byArray = new byte[n * nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[n2++] = (byte)(nArray[i] >> 16 & 0xFF);
                byArray[n2++] = (byte)(nArray[i] >> 8 & 0xFF);
                int n3 = n2++;
                int n4 = n2++;
                byte by = (byte)(nArray[i] & 0xFF);
                byArray[n4] = by;
                byArray[n3] = by;
            }
            ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.flip();
            int[] nArray2 = new int[1];
            gL2.glGenTextures(1, nArray2, 0);
            gL2.glBindTexture(3553, nArray2[0]);
            gL2.glTexImage2D(3553, 0, 6408, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 6408, 5121, (Buffer)byteBuffer);
            gL2.glTexParameteri(3553, 10241, 9728);
            gL2.glTexParameteri(3553, 10240, 9728);
            return nArray2[0];
        }

        private int nextPowerOfTwo(int n) {
            for (int i = 1; i <= 16; i <<= 1) {
                n |= n >> i;
            }
            return n + 1;
        }

        private Rectangle calcTexBounds(Rectangle rectangle) {
            int n = this.nextPowerOfTwo((int)rectangle.getWidth());
            int n2 = this.nextPowerOfTwo((int)rectangle.getHeight());
            return new Rectangle(n, n2);
        }
    }
}

