/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.vis.text;

import com.sun.opengl.util.BufferUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;

public interface Glyph {
    public boolean isWhitespace();

    public Pixels renderPixels();

    public static class CharacterGlyph
    implements Glyph {
        private char m_c;
        private Font m_font;

        public CharacterGlyph(char c, Font font) {
            this.m_c = c;
            this.m_font = font;
        }

        public boolean isWhitespace() {
            return Character.isWhitespace(this.getChar());
        }

        public Pixels renderPixels() {
            return Renderer.getPixels(this);
        }

        public char getChar() {
            return this.m_c;
        }

        public Font getFont() {
            return this.m_font;
        }

        public boolean equals(Object object) {
            return object instanceof CharacterGlyph && ((CharacterGlyph)object).getChar() == this.getChar() && ((CharacterGlyph)object).getFont().equals(this.getFont());
        }

        public int hashCode() {
            return this.getChar() * 33 ^ this.getFont().hashCode();
        }

        private static class Renderer {
            private static final int BYTES_PER_PIXEL = 4;

            private Renderer() {
            }

            public static Pixels getPixels(CharacterGlyph characterGlyph) {
                FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
                TextLayout textLayout = new TextLayout(Character.toString(characterGlyph.getChar()), characterGlyph.getFont(), fontRenderContext);
                int n = (int)textLayout.getVisibleAdvance();
                int n2 = (int)(1.1 * (double)textLayout.getAscent() + (double)textLayout.getDescent());
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setPaint(Color.WHITE);
                textLayout.draw(graphics2D, 0.0f, textLayout.getAscent());
                int n3 = n * n2 * 4;
                ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)n3);
                for (int n4 : bufferedImage.getRGB(0, 0, n, n2, null, 0, n)) {
                    byteBuffer.put((byte)(n4 >> 16 & 0xFF));
                    byteBuffer.put((byte)(n4 >> 8 & 0xFF));
                    byteBuffer.put((byte)(n4 & 0xFF));
                    byteBuffer.put((byte)(n4 >> 24 & 0xFF));
                }
                byteBuffer.flip();
                return new Pixels(n, n2, byteBuffer);
            }
        }
    }

    public static class Pixels {
        private int m_width;
        private int m_height;
        private ByteBuffer m_buffer;

        public Pixels(int n, int n2, ByteBuffer byteBuffer) {
            this.m_width = n;
            this.m_height = n2;
            this.m_buffer = byteBuffer;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }

        public ByteBuffer getBuffer() {
            return this.m_buffer;
        }
    }
}

