/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.owlapi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.glowvis.data.CompoundGraph;
import org.glowvis.data.CompoundGraphBuilder;
import org.glowvis.data.RenderableNode;
import org.glowvis.owlapi.RuleSetNotSelectedException;
import org.glowvis.owlapi.Util;
import org.glowvis.owlapi.access.NotSupportedException;
import org.glowvis.owlapi.access.OntologyAccess;
import org.glowvis.owlapi.data.ClassNode;
import org.glowvis.owlapi.data.Node;
import org.glowvis.owlapi.ruleset.edge.EdgeRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.HierarchyRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.SubclassHierarchyRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.SubclassTypeHierarchyRuleSet;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyReader {
    private Set<OWLOntology> m_ontologies;
    private OWLOntologyManager m_manager;
    private OntologyAccess m_ontologyAccess;
    private ArrayList<HierarchyRuleSet> m_defaultHierarchyRuleSets;
    private HierarchyRuleSet m_hierarchyRuleSet;
    private EdgeRuleSet m_edgeRuleSet;

    public OntologyReader(Set<OWLOntology> set, OWLOntologyManager oWLOntologyManager, OWLReasoner oWLReasoner) {
        this.m_ontologies = set;
        this.m_manager = oWLOntologyManager;
        this.setReasoner(oWLOntologyManager, oWLReasoner);
        Util.debug("Using ontologies:     " + this.m_ontologies, 3);
        Util.debug("Using manager:        " + this.m_manager, 3);
    }

    public OntologyReader(OWLOntology oWLOntology, OWLOntologyManager oWLOntologyManager, OWLReasoner oWLReasoner) {
        this(Collections.singleton(oWLOntology), oWLOntologyManager, oWLReasoner);
    }

    public void setReasoner(OWLOntologyManager oWLOntologyManager, OWLReasoner oWLReasoner) {
        this.m_ontologyAccess = OntologyAccess.create(oWLOntologyManager, oWLReasoner);
        Util.debug("Using ontologyAccess: " + this.m_ontologyAccess, 3);
    }

    public String toString() {
        String string = "[" + this.getClass().getSimpleName() + " ontologies=" + this.m_ontologies + " manager=" + this.m_manager + " ontologyAccess=" + this.m_ontologyAccess + "]";
        return string;
    }

    public void loadOntology() throws OWLReasonerException {
        Util.debug("Loading ontologies", 4);
        this.getAccess().loadOntologies(this.m_ontologies);
    }

    public void unloadOntology() throws OWLReasonerException {
        Util.debug("Unloading ontologies", 4);
        this.getAccess().unloadOntologies(this.m_ontologies);
    }

    private boolean checkRuleSets() throws RuleSetNotSelectedException {
        boolean bl = true;
        if (this.m_hierarchyRuleSet == null) {
            bl = false;
        } else if (this.m_edgeRuleSet == null) {
            bl = false;
        } else if (this.m_edgeRuleSet.getHierarchyRuleSet() != this.m_hierarchyRuleSet) {
            bl = false;
        }
        if (!bl) {
            throw new RuleSetNotSelectedException();
        }
        return true;
    }

    public Iterable<HierarchyRuleSet> getHierarchyRuleSets() {
        if (this.m_defaultHierarchyRuleSets == null) {
            this.m_defaultHierarchyRuleSets = this.getDefaultHierarchyRuleSets();
        }
        return this.m_defaultHierarchyRuleSets;
    }

    public void addHierarchyRuleSet(HierarchyRuleSet hierarchyRuleSet) {
        this.getHierarchyRuleSets();
        this.m_defaultHierarchyRuleSets.add(hierarchyRuleSet);
    }

    private ArrayList<HierarchyRuleSet> getDefaultHierarchyRuleSets() {
        ArrayList<HierarchyRuleSet> arrayList = new ArrayList<HierarchyRuleSet>();
        arrayList.add(new SubclassHierarchyRuleSet(this));
        arrayList.add(new SubclassTypeHierarchyRuleSet(this));
        return arrayList;
    }

    public HierarchyRuleSet getDefaultHierarchyRuleSet() {
        Iterable<HierarchyRuleSet> iterable = this.getHierarchyRuleSets();
        HierarchyRuleSet hierarchyRuleSet = iterable.iterator().next();
        return hierarchyRuleSet;
    }

    public void setHierarchyRuleSet(HierarchyRuleSet hierarchyRuleSet) {
        this.m_hierarchyRuleSet = hierarchyRuleSet;
        this.m_edgeRuleSet = null;
    }

    public void setEdgeRuleSet(EdgeRuleSet edgeRuleSet) {
        this.m_edgeRuleSet = edgeRuleSet;
    }

    public HierarchyRuleSet getCurrentHierarchyRuleSet() {
        return this.m_hierarchyRuleSet;
    }

    public EdgeRuleSet getCurrentEdgeRuleSet() {
        return this.m_edgeRuleSet;
    }

    public OntologyAccess getAccess() {
        if (this.m_ontologyAccess == null) {
            this.m_ontologyAccess = OntologyAccess.create(this.m_manager, null);
        }
        return this.m_ontologyAccess;
    }

    public Set<OWLOntology> getOntologies() {
        return this.m_ontologies;
    }

    public OWLOntologyManager getManager() {
        return this.m_manager;
    }

    public OWLClass getThing() {
        URI uRI = OWLRDFVocabulary.OWL_THING.getURI();
        OWLClass oWLClass = this.getManager().getOWLDataFactory().getOWLClass(uRI);
        return oWLClass;
    }

    public CompoundGraph createCompoundGraph(OWLClass oWLClass) throws RuleSetNotSelectedException, OWLReasonerException, NotSupportedException {
        if (oWLClass == null) {
            oWLClass = this.getThing();
        }
        this.checkRuleSets();
        this.loadOntology();
        ClassNode classNode = new ClassNode(oWLClass);
        CompoundGraphBuilder compoundGraphBuilder = CompoundGraph.createBuilder();
        Util.debug("Calling addRoot with node: " + (Object)((Object)classNode), 4);
        compoundGraphBuilder.addRoot((RenderableNode)classNode);
        Util.debug("Creating hierarchy", 4);
        Map<String, Node> map = this.m_hierarchyRuleSet.createHierarchy(compoundGraphBuilder, classNode);
        Util.debug("Creating adjacency edges", 4);
        this.m_edgeRuleSet.createAdjacencyEdges(compoundGraphBuilder, map);
        CompoundGraph compoundGraph = compoundGraphBuilder.getCompoundGraph();
        this.unloadOntology();
        return compoundGraph;
    }
}

