/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.owlapi.access;

import java.util.HashSet;
import java.util.Set;
import org.glowvis.owlapi.access.NotSupportedException;
import org.glowvis.owlapi.access.ReasonerOntologyAccess;
import org.glowvis.owlapi.access.StaticOntologyAccess;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OntologyAccess {
    protected abstract Set<Set<OWLClass>> fetchSubClasses(OWLClass var1) throws OWLReasonerException, NotSupportedException;

    protected abstract boolean isAcceptableChildClass(OWLClass var1, OWLClass var2) throws OWLReasonerException, NotSupportedException;

    public abstract Set<OWLIndividual> getIndividualsOfClass(OWLClass var1) throws OWLReasonerException, NotSupportedException;

    public abstract void loadOntologies(Set<OWLOntology> var1) throws OWLReasonerException;

    public abstract void unloadOntologies(Set<OWLOntology> var1) throws OWLReasonerException;

    public final Set<OWLClass> getSubClasses(OWLClass oWLClass) throws OWLReasonerException, NotSupportedException {
        Set<Set<OWLClass>> set = this.fetchSubClasses(oWLClass);
        HashSet<OWLClass> hashSet = new HashSet<OWLClass>();
        for (Set<OWLClass> set2 : set) {
            for (OWLClass oWLClass2 : set2) {
                if (!this.isAcceptableChildClass(oWLClass, oWLClass2)) continue;
                hashSet.add(oWLClass2);
            }
        }
        return hashSet;
    }

    public static OntologyAccess create(OWLOntologyManager oWLOntologyManager, OWLReasoner oWLReasoner) {
        OntologyAccess ontologyAccess = oWLReasoner != null ? new ReasonerOntologyAccess(oWLReasoner) : new StaticOntologyAccess(oWLOntologyManager);
        return ontologyAccess;
    }

    public String toString() {
        String string = "[" + this.getClass().getSimpleName() + "]";
        return string;
    }
}

