/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.owlapi.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glowvis.owlapi.OntologyReader;
import org.glowvis.owlapi.access.Property;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyProvider {
    private OntologyReader m_reader;

    public PropertyProvider(OntologyReader ontologyReader) {
        this.m_reader = ontologyReader;
    }

    public Iterable<Property> getProperties() {
        HashMap<String, OWLObjectPropertyDomainAxiom> hashMap = new HashMap<String, OWLObjectPropertyDomainAxiom>();
        HashMap<String, OWLObjectPropertyRangeAxiom> hashMap2 = new HashMap<String, OWLObjectPropertyRangeAxiom>();
        this.loadPropertyAxioms(hashMap, hashMap2);
        Iterable<Property> iterable = this.buildProperties(hashMap, hashMap2);
        return iterable;
    }

    private OntologyReader getReader() {
        return this.m_reader;
    }

    private void loadPropertyAxioms(Map<String, OWLObjectPropertyDomainAxiom> map, Map<String, OWLObjectPropertyRangeAxiom> map2) {
        for (OWLOntology oWLOntology : this.getReader().getOntologies()) {
            Set set = oWLOntology.getObjectPropertyAxioms();
            for (OWLPropertyAxiom oWLPropertyAxiom : set) {
                String string;
                OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom;
                if (oWLPropertyAxiom.getAxiomType() == AxiomType.OBJECT_PROPERTY_DOMAIN) {
                    oWLObjectPropertyDomainAxiom = (OWLObjectPropertyDomainAxiom)oWLPropertyAxiom;
                    string = "" + oWLObjectPropertyDomainAxiom.getProperty();
                    if (string.equals("")) continue;
                    map.put(string, oWLObjectPropertyDomainAxiom);
                    continue;
                }
                if (oWLPropertyAxiom.getAxiomType() != AxiomType.OBJECT_PROPERTY_RANGE) continue;
                oWLObjectPropertyDomainAxiom = (OWLObjectPropertyRangeAxiom)oWLPropertyAxiom;
                string = "" + oWLObjectPropertyDomainAxiom.getProperty();
                if (string.equals("")) continue;
                map2.put(string, (OWLObjectPropertyRangeAxiom)oWLObjectPropertyDomainAxiom);
            }
        }
    }

    private Iterable<Property> buildProperties(Map<String, OWLObjectPropertyDomainAxiom> map, Map<String, OWLObjectPropertyRangeAxiom> map2) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (String string : map.keySet()) {
            OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom = map.get(string);
            OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom = map2.get(string);
            if (oWLObjectPropertyRangeAxiom == null) continue;
            OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)oWLObjectPropertyDomainAxiom.getProperty();
            OWLDescription oWLDescription = oWLObjectPropertyDomainAxiom.getDomain();
            OWLDescription oWLDescription2 = (OWLDescription)oWLObjectPropertyRangeAxiom.getRange();
            Property property = new Property(oWLObjectPropertyExpression, oWLDescription, oWLDescription2);
            arrayList.add(property);
        }
        return arrayList;
    }
}

