/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.owlapi.access;

import java.util.HashSet;
import java.util.Set;
import org.glowvis.owlapi.access.NotSupportedException;
import org.glowvis.owlapi.access.OntologyAccess;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.ToldClassHierarchyReasoner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticOntologyAccess
extends OntologyAccess {
    private OWLClassReasoner m_toldClassHierarchyReasoner;
    private HashSet<OWLOntology> m_ontologies;

    public StaticOntologyAccess(OWLOntologyManager oWLOntologyManager) {
        this.m_toldClassHierarchyReasoner = new ToldClassHierarchyReasoner(oWLOntologyManager);
    }

    @Override
    public void loadOntologies(Set<OWLOntology> set) throws OWLReasonerException {
        this.m_toldClassHierarchyReasoner.loadOntologies(set);
        for (OWLOntology oWLOntology : set) {
            this.getOntologies().add(oWLOntology);
        }
    }

    @Override
    public void unloadOntologies(Set<OWLOntology> set) throws OWLReasonerException {
        this.m_toldClassHierarchyReasoner.unloadOntologies(set);
        for (OWLOntology oWLOntology : set) {
            this.getOntologies().remove(oWLOntology);
        }
    }

    @Override
    protected Set<Set<OWLClass>> fetchSubClasses(OWLClass oWLClass) throws OWLReasonerException {
        return this.m_toldClassHierarchyReasoner.getSubClasses((OWLDescription)oWLClass);
    }

    @Override
    protected boolean isAcceptableChildClass(OWLClass oWLClass, OWLClass oWLClass2) throws OWLReasonerException {
        return !oWLClass.equals(oWLClass2);
    }

    @Override
    public Set<OWLIndividual> getIndividualsOfClass(OWLClass oWLClass) throws NotSupportedException {
        HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
        for (OWLOntology oWLOntology : this.m_ontologies) {
            for (OWLIndividual oWLIndividual : oWLOntology.getIndividualsInSignature()) {
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : oWLOntology.getClassAssertionAxioms(oWLIndividual)) {
                    if (oWLClassAssertionAxiom.getDescription().isAnonymous() || !oWLClassAssertionAxiom.getDescription().asOWLClass().equals(oWLClass)) continue;
                    hashSet.add(oWLIndividual);
                }
            }
        }
        return hashSet;
    }

    private HashSet<OWLOntology> getOntologies() {
        if (this.m_ontologies == null) {
            this.m_ontologies = new HashSet();
        }
        return this.m_ontologies;
    }
}

