/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.owlapi.ruleset.edge;

import java.util.Map;
import org.glowvis.data.CompoundGraphBuilder;
import org.glowvis.data.RenderableEdge;
import org.glowvis.owlapi.OntologyReader;
import org.glowvis.owlapi.Util;
import org.glowvis.owlapi.access.NotSupportedException;
import org.glowvis.owlapi.data.Edge;
import org.glowvis.owlapi.data.Node;
import org.glowvis.owlapi.ruleset.AbstractRuleSet;
import org.glowvis.owlapi.ruleset.edge.EdgeFilter;
import org.glowvis.owlapi.ruleset.edge.EdgeFinder;
import org.glowvis.owlapi.ruleset.edge.EdgeRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.HierarchyRuleSet;
import org.semanticweb.owl.inference.OWLReasonerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEdgeRuleSet
extends AbstractRuleSet
implements EdgeRuleSet {
    private HierarchyRuleSet m_hierarchyRuleSet;

    protected abstract Iterable<EdgeFinder> getEdgeFinders();

    public AbstractEdgeRuleSet(HierarchyRuleSet hierarchyRuleSet, OntologyReader ontologyReader) {
        super(ontologyReader);
        this.m_hierarchyRuleSet = hierarchyRuleSet;
    }

    @Override
    public HierarchyRuleSet getHierarchyRuleSet() {
        return this.m_hierarchyRuleSet;
    }

    @Override
    public final void createAdjacencyEdges(CompoundGraphBuilder compoundGraphBuilder, Map<String, Node> map) throws OWLReasonerException, NotSupportedException {
        Util.debug("Creating edges", 5);
        Iterable<EdgeFinder> iterable = this.getEdgeFinders();
        EdgeFilter edgeFilter = new EdgeFilter(this.getReader());
        if (iterable != null) {
            for (EdgeFinder edgeFinder : iterable) {
                Iterable<Edge> iterable2 = edgeFinder.getAdjacencyEdges();
                if (iterable2 == null) continue;
                for (Edge edge : iterable2) {
                    if (edgeFilter.isAcceptableEdge(edge, map)) {
                        Util.debug("Calling addAdjacencyEdge() with edge: " + (Object)((Object)edge), 4);
                        compoundGraphBuilder.addAdjacencyEdge((RenderableEdge)edge);
                        continue;
                    }
                    Util.debug("EdgeFilter has filtered an edge, ignoring: " + (Object)((Object)edge), 4);
                }
            }
        } else {
            Util.debug("No EdgeFinders available for rule set: " + this, 3);
        }
    }
}

