/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.owlapi.ruleset.edge;

import java.util.ArrayList;
import org.glowvis.owlapi.OntologyReader;
import org.glowvis.owlapi.access.Property;
import org.glowvis.owlapi.access.PropertyProvider;
import org.glowvis.owlapi.data.ClassNode;
import org.glowvis.owlapi.data.Edge;
import org.glowvis.owlapi.ruleset.edge.EdgeFinder;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEdgeFinder
extends EdgeFinder {
    public PropertyEdgeFinder(OntologyReader ontologyReader) {
        super(ontologyReader);
    }

    @Override
    public Iterable<Edge> getAdjacencyEdges() {
        PropertyProvider propertyProvider = new PropertyProvider(this.getReader());
        Iterable<Property> iterable = propertyProvider.getProperties();
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Property property : iterable) {
            if (!property.domainAndRangeNamed()) continue;
            Edge edge = this.buildEdge(property);
            arrayList.add(edge);
        }
        return arrayList;
    }

    private Edge buildEdge(Property property) {
        OWLDescription oWLDescription = property.getDomain();
        OWLClass oWLClass = oWLDescription.asOWLClass();
        ClassNode classNode = new ClassNode(oWLClass);
        OWLDescription oWLDescription2 = property.getRange();
        OWLClass oWLClass2 = oWLDescription2.asOWLClass();
        ClassNode classNode2 = new ClassNode(oWLClass2);
        String string = "Property '" + property.getName() + "': domain '" + oWLClass + "', range '" + oWLClass2 + "'";
        String string2 = "Property:" + property.getName() + ":" + oWLClass + ":" + oWLClass2;
        Edge edge = new Edge(classNode, classNode2, string, string2);
        return edge;
    }
}

