/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.owlapi.ruleset.edge;

import java.util.ArrayList;
import org.glowvis.owlapi.OntologyReader;
import org.glowvis.owlapi.Util;
import org.glowvis.owlapi.access.NotSupportedException;
import org.glowvis.owlapi.access.Property;
import org.glowvis.owlapi.data.Edge;
import org.glowvis.owlapi.data.IndividualNode;
import org.glowvis.owlapi.ruleset.edge.EdgeFinder;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationEdgeFinder
extends EdgeFinder {
    private Property m_property;
    private String m_propertyName;

    public RelationEdgeFinder(OntologyReader ontologyReader, Property property) {
        super(ontologyReader);
        this.m_property = property;
        this.m_propertyName = property != null ? property.getName() : null;
    }

    public Property getProperty() {
        return this.m_property;
    }

    @Override
    public Iterable<Edge> getAdjacencyEdges() throws OWLReasonerException, NotSupportedException {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Iterable<OWLObjectPropertyAssertionAxiom> iterable = this.getObjectPropertyAssertionAxioms();
        for (OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom : iterable) {
            Edge edge = this.buildEdge(oWLObjectPropertyAssertionAxiom);
            arrayList.add(edge);
        }
        return arrayList;
    }

    private Iterable<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms() {
        ArrayList<OWLObjectPropertyAssertionAxiom> arrayList = new ArrayList<OWLObjectPropertyAssertionAxiom>();
        for (OWLOntology oWLOntology : this.getOntologies()) {
            for (OWLIndividual oWLIndividual : oWLOntology.getIndividualsInSignature()) {
                Util.debug("Individual: " + oWLIndividual.getClass() + ": " + oWLIndividual, 5);
                for (OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom : oWLOntology.getObjectPropertyAssertionAxioms(oWLIndividual)) {
                    String string = "" + oWLObjectPropertyAssertionAxiom.getProperty();
                    Util.debug("  Opa: " + oWLObjectPropertyAssertionAxiom, 5);
                    Util.debug("    Property: " + string, 5);
                    Util.debug("    Subject:  " + oWLObjectPropertyAssertionAxiom.getSubject(), 5);
                    Util.debug("    Object:   " + oWLObjectPropertyAssertionAxiom.getObject(), 5);
                    if (this.axiomMatches(oWLObjectPropertyAssertionAxiom)) {
                        Util.debug("    MATCH!", 5);
                        arrayList.add(oWLObjectPropertyAssertionAxiom);
                        continue;
                    }
                    Util.debug("    No match!", 5);
                }
            }
        }
        return arrayList;
    }

    private boolean axiomMatches(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        if (this.m_property == null) {
            return true;
        }
        return this.m_propertyName.equals("" + oWLObjectPropertyAssertionAxiom.getProperty());
    }

    private Edge buildEdge(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLObjectPropertyAssertionAxiom.getSubject();
        IndividualNode individualNode = new IndividualNode(oWLIndividual);
        OWLIndividual oWLIndividual2 = (OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject();
        IndividualNode individualNode2 = new IndividualNode(oWLIndividual2);
        String string = "" + oWLIndividual + " " + oWLObjectPropertyAssertionAxiom.getProperty() + " " + oWLIndividual2;
        String string2 = "Relation:" + oWLObjectPropertyAssertionAxiom.getProperty() + ":" + oWLIndividual + ":" + oWLIndividual2;
        Edge edge = new Edge(individualNode, individualNode2, string, string2);
        return edge;
    }
}

