/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.owlapi.ruleset.hierarchy;

import java.util.HashMap;
import java.util.Map;
import org.glowvis.data.CompoundGraphBuilder;
import org.glowvis.data.RenderableEdge;
import org.glowvis.owlapi.OntologyReader;
import org.glowvis.owlapi.Util;
import org.glowvis.owlapi.access.NotSupportedException;
import org.glowvis.owlapi.data.Edge;
import org.glowvis.owlapi.data.Node;
import org.glowvis.owlapi.ruleset.AbstractRuleSet;
import org.glowvis.owlapi.ruleset.edge.EdgeRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.HierarchyRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.NodeFinder;
import org.semanticweb.owl.inference.OWLReasonerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHierarchyRuleSet
extends AbstractRuleSet
implements HierarchyRuleSet {
    @Override
    public abstract Iterable<EdgeRuleSet> getEdgeRuleSets();

    public AbstractHierarchyRuleSet(OntologyReader ontologyReader) {
        super(ontologyReader);
    }

    @Override
    public EdgeRuleSet getDefaultEdgeRuleSet() {
        Iterable<EdgeRuleSet> iterable = this.getEdgeRuleSets();
        EdgeRuleSet edgeRuleSet = iterable.iterator().next();
        return edgeRuleSet;
    }

    @Override
    public final Map<String, Node> createHierarchy(CompoundGraphBuilder compoundGraphBuilder, Node node) throws OWLReasonerException, NotSupportedException {
        Util.debug("Creating hierarchy: parent: " + (Object)((Object)node), 5);
        Iterable<NodeFinder> iterable = this.getNodeFinders();
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        hashMap.put(node.getKey(), node);
        if (iterable != null) {
            for (NodeFinder nodeFinder : iterable) {
                Iterable<Node> iterable2 = nodeFinder.getChildNodes(node);
                for (Node node2 : iterable2) {
                    Edge edge = new Edge(node, node2);
                    Util.debug("Calling addInclusion with edge: " + (Object)((Object)edge), 4);
                    compoundGraphBuilder.addInclusion((RenderableEdge)edge);
                    hashMap.put(node2.getKey(), node2);
                    Map<String, Node> map = this.createHierarchy(compoundGraphBuilder, node2);
                    hashMap.putAll(map);
                }
            }
        }
        return hashMap;
    }
}

