/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.protege;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.glowvis.data.Configuration;
import org.glowvis.vis.gl.GLDisplay;
import org.glowvis.vis.gl.render.GLEdgeRenderer;
import org.glowvis.vis.gl.render.GLNodeRenderer;

public class AdvancedConfigurationFrame
extends JFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 6524349403467704418L;
    private Configuration configuration;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JLabel backgroundColorLabel;
    private JButton backgroundColorButton;
    private JLabel nodeEnableLabel;
    private JCheckBox nodeEnableCheckbox;
    private JLabel showInclusionEdgesLabel;
    private JCheckBox inclusionEdgeEnableCheckbox;
    private JLabel inclusionEdgeSourceColorlabel;
    private JButton inclusionEdgeSourceColorButton;
    private JLabel inclusionEdgeTargetColorLabel;
    private JButton inclusionEdgeTargetColorButton;
    private JLabel inclusionEdgeOpacityLabel;
    private JSlider inclusionEdgeOpacitySlider;
    private JLabel adjacencyEdgeSourceColorLabel;
    private JButton adjacencyEdgeSourceColorButton;
    private JLabel adjacencyEdgeTargetColorLabel;
    private JButton adjacencyEdgeTargetColorButton;
    private JLabel adjacencyEdgeOpacityLabel;
    private JSlider adjacencyEdgeOpacitySlider;
    private JLabel nodeColorLabel;
    private JButton nodeColorButton;
    private JButton closeButton;

    public AdvancedConfigurationFrame() {
        this.initComponents();
    }

    public AdvancedConfigurationFrame(Configuration configuration) {
        this();
        this.configuration = configuration;
        if (configuration != null) {
            GLEdgeRenderer.GLEdgeRendererConfiguration gLEdgeRendererConfiguration = (GLEdgeRenderer.GLEdgeRendererConfiguration)configuration.getSubgroup("Inclusion edges");
            this.inclusionEdgeEnableCheckbox.setSelected(gLEdgeRendererConfiguration.getIsEnabled());
            this.inclusionEdgeOpacitySlider.setValue((int)Math.round(gLEdgeRendererConfiguration.getAlphaComponent() * (double)this.inclusionEdgeOpacitySlider.getMaximum()));
            GLEdgeRenderer.GLEdgeRendererConfiguration gLEdgeRendererConfiguration2 = (GLEdgeRenderer.GLEdgeRendererConfiguration)configuration.getSubgroup("Adjacency edges");
            this.adjacencyEdgeOpacitySlider.setValue((int)Math.round(gLEdgeRendererConfiguration2.getAlphaComponent() * (double)this.adjacencyEdgeOpacitySlider.getMaximum()));
            GLNodeRenderer.GLNodeRendererConfiguration gLNodeRendererConfiguration = (GLNodeRenderer.GLNodeRendererConfiguration)configuration.getSubgroup("Nodes");
            this.nodeEnableCheckbox.setSelected(gLNodeRendererConfiguration.getIsEnabled());
        }
        this.backgroundColorButton.addActionListener(this);
        this.inclusionEdgeSourceColorButton.addActionListener(this);
        this.inclusionEdgeTargetColorButton.addActionListener(this);
        this.inclusionEdgeOpacitySlider.addChangeListener(this);
        this.adjacencyEdgeSourceColorButton.addActionListener(this);
        this.adjacencyEdgeTargetColorButton.addActionListener(this);
        this.adjacencyEdgeOpacitySlider.addChangeListener(this);
        this.inclusionEdgeEnableCheckbox.addActionListener(this);
        this.nodeEnableCheckbox.addActionListener(this);
        this.nodeColorButton.addActionListener(this);
        this.closeButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        Object object = actionEvent.getSource();
        GLDisplay.DisplayConfiguration displayConfiguration = (GLDisplay.DisplayConfiguration)this.configuration.getSubgroup("Display");
        GLEdgeRenderer.GLEdgeRendererConfiguration gLEdgeRendererConfiguration = (GLEdgeRenderer.GLEdgeRendererConfiguration)this.configuration.getSubgroup("Inclusion edges");
        GLEdgeRenderer.GLEdgeRendererConfiguration gLEdgeRendererConfiguration2 = (GLEdgeRenderer.GLEdgeRendererConfiguration)this.configuration.getSubgroup("Adjacency edges");
        GLNodeRenderer.GLNodeRendererConfiguration gLNodeRendererConfiguration = (GLNodeRenderer.GLNodeRendererConfiguration)this.configuration.getSubgroup("Nodes");
        if (object.equals(this.backgroundColorButton)) {
            color = this.updateColor(displayConfiguration.getBackgroundColor(), "background color");
            displayConfiguration.setBackgroundColor(color);
        }
        if (object.equals(this.adjacencyEdgeSourceColorButton)) {
            color = this.updateColor(gLEdgeRendererConfiguration2.getSourceColor(), "adjacency edges - source color");
            gLEdgeRendererConfiguration2.setSourceColor(color);
        }
        if (object.equals(this.adjacencyEdgeTargetColorButton)) {
            color = this.updateColor(gLEdgeRendererConfiguration2.getTargetColor(), "adjacency edges - target color");
            gLEdgeRendererConfiguration2.setTargetColor(color);
        }
        if (object.equals(this.inclusionEdgeSourceColorButton)) {
            color = this.updateColor(gLEdgeRendererConfiguration.getSourceColor(), "inclusion edges - source color");
            gLEdgeRendererConfiguration.setSourceColor(color);
        }
        if (object.equals(this.inclusionEdgeTargetColorButton)) {
            color = this.updateColor(gLEdgeRendererConfiguration.getTargetColor(), "inclusion edges - target color");
            gLEdgeRendererConfiguration.setTargetColor(color);
        }
        if (object.equals(this.nodeColorButton)) {
            color = this.updateColor(gLNodeRendererConfiguration.getNodeColor(), "node color");
            gLNodeRendererConfiguration.setNodeColor(color);
        }
        if (object.equals(this.inclusionEdgeEnableCheckbox)) {
            this.updateBoolean(gLEdgeRendererConfiguration.getEnabledItem(), ((JCheckBox)object).isSelected());
        }
        if (object.equals(this.nodeEnableCheckbox)) {
            this.updateBoolean(gLNodeRendererConfiguration.getEnabledItem(), ((JCheckBox)object).isSelected());
        }
        if (object.equals(this.closeButton)) {
            this.setVisible(false);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        GLEdgeRenderer.GLEdgeRendererConfiguration gLEdgeRendererConfiguration;
        JSlider jSlider = (JSlider)changeEvent.getSource();
        double d = (double)jSlider.getValue() / (double)jSlider.getMaximum();
        if (jSlider.equals(this.inclusionEdgeOpacitySlider)) {
            gLEdgeRendererConfiguration = (GLEdgeRenderer.GLEdgeRendererConfiguration)this.configuration.getSubgroup("Inclusion edges");
            gLEdgeRendererConfiguration.setAlphaComponent(d);
        }
        if (jSlider.equals(this.adjacencyEdgeOpacitySlider)) {
            gLEdgeRendererConfiguration = (GLEdgeRenderer.GLEdgeRendererConfiguration)this.configuration.getSubgroup("Adjacency edges");
            gLEdgeRendererConfiguration.setAlphaComponent(d);
        }
    }

    private Color updateColor(Color color, String string) {
        assert (color != null);
        return JColorChooser.showDialog(this, "GLOW Visualization: " + string, color);
    }

    private void updateBoolean(Configuration.ConfigurationItem configurationItem, boolean bl) {
        assert (configurationItem != null);
        configurationItem.setValue((Object)bl);
    }

    private void updateDouble(Configuration.ConfigurationItem configurationItem, double d) {
        assert (configurationItem != null);
        configurationItem.setValue((Object)d);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.backgroundColorLabel = new JLabel();
        this.backgroundColorButton = new JButton();
        this.nodeEnableLabel = new JLabel();
        this.nodeEnableCheckbox = new JCheckBox();
        this.showInclusionEdgesLabel = new JLabel();
        this.inclusionEdgeEnableCheckbox = new JCheckBox();
        this.inclusionEdgeSourceColorlabel = new JLabel();
        this.inclusionEdgeSourceColorButton = new JButton();
        this.inclusionEdgeTargetColorLabel = new JLabel();
        this.inclusionEdgeTargetColorButton = new JButton();
        this.inclusionEdgeOpacityLabel = new JLabel();
        this.inclusionEdgeOpacitySlider = new JSlider();
        this.adjacencyEdgeSourceColorLabel = new JLabel();
        this.adjacencyEdgeSourceColorButton = new JButton();
        this.adjacencyEdgeTargetColorLabel = new JLabel();
        this.adjacencyEdgeTargetColorButton = new JButton();
        this.adjacencyEdgeOpacityLabel = new JLabel();
        this.adjacencyEdgeOpacitySlider = new JSlider();
        this.nodeColorLabel = new JLabel();
        this.nodeColorButton = new JButton();
        this.closeButton = new JButton();
        this.setTitle("GLOW Visualization: Advanced");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new GridLayout());
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0};
        this.backgroundColorLabel.setText("Background color");
        this.buttonBar.add((Component)this.backgroundColorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.backgroundColorButton.setText("Change...");
        this.buttonBar.add((Component)this.backgroundColorButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.nodeEnableLabel.setText("Show nodes");
        this.buttonBar.add((Component)this.nodeEnableLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.nodeEnableCheckbox.setText("Enabled");
        this.buttonBar.add((Component)this.nodeEnableCheckbox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.showInclusionEdgesLabel.setText("Show inclusion edges");
        this.buttonBar.add((Component)this.showInclusionEdgesLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.inclusionEdgeEnableCheckbox.setText("Enabled");
        this.buttonBar.add((Component)this.inclusionEdgeEnableCheckbox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.inclusionEdgeSourceColorlabel.setText("Inclusion edge source color");
        this.buttonBar.add((Component)this.inclusionEdgeSourceColorlabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.inclusionEdgeSourceColorButton.setText("Change...");
        this.buttonBar.add((Component)this.inclusionEdgeSourceColorButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.inclusionEdgeTargetColorLabel.setText("Inclusion edge target color");
        this.buttonBar.add((Component)this.inclusionEdgeTargetColorLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.inclusionEdgeTargetColorButton.setText("Change...");
        this.buttonBar.add((Component)this.inclusionEdgeTargetColorButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.inclusionEdgeOpacityLabel.setText("Inclusion edge opacity");
        this.buttonBar.add((Component)this.inclusionEdgeOpacityLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.buttonBar.add((Component)this.inclusionEdgeOpacitySlider, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.adjacencyEdgeSourceColorLabel.setText("Adjacency edge source color");
        this.buttonBar.add((Component)this.adjacencyEdgeSourceColorLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.adjacencyEdgeSourceColorButton.setText("Change...");
        this.buttonBar.add((Component)this.adjacencyEdgeSourceColorButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.adjacencyEdgeTargetColorLabel.setText("Adjacency edge target color");
        this.buttonBar.add((Component)this.adjacencyEdgeTargetColorLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.adjacencyEdgeTargetColorButton.setText("Change...");
        this.buttonBar.add((Component)this.adjacencyEdgeTargetColorButton, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.adjacencyEdgeOpacityLabel.setText("Adjacency edge opacity");
        this.buttonBar.add((Component)this.adjacencyEdgeOpacityLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.buttonBar.add((Component)this.adjacencyEdgeOpacitySlider, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.nodeColorLabel.setText("Node/Label color");
        this.buttonBar.add((Component)this.nodeColorLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.nodeColorButton.setText("Change...");
        this.buttonBar.add((Component)this.nodeColorButton, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.closeButton.setText("Close Window");
        this.closeButton.setIcon(null);
        this.closeButton.setMnemonic('C');
        this.buttonBar.add((Component)this.closeButton, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dialogPane.add(this.buttonBar);
        container.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

