/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.protege;

import java.awt.BorderLayout;
import org.glowvis.owlapi.OntologyReader;
import org.glowvis.owlapi.Util;
import org.glowvis.owlapi.ruleset.hierarchy.HierarchyRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.SubclassTypeHierarchyRuleSet;
import org.glowvis.protege.HierarchyProviderAdapter;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.view.AbstractOWLSelectionViewComponent;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyBrowserViewComponent
extends AbstractOWLSelectionViewComponent {
    private static final long serialVersionUID = 6052736031339881760L;
    private OWLObjectTree<OWLObject> m_tree;
    OntologyReader m_reader;
    OWLObjectHierarchyProvider<OWLObject> m_hierarchyprovider;

    public void initialiseView() throws Exception {
        this.setLayout(new BorderLayout());
        this.m_reader = this.createOntologyReader();
        this.m_reader.loadOntology();
        this.m_hierarchyprovider = new HierarchyProviderAdapter(this.m_reader);
        this.m_tree = new OWLModelManagerTree(this.getOWLEditorKit(), this.getHierarchyProvider());
        this.add(ComponentFactory.createScrollPane(this.m_tree));
    }

    protected OWLObject updateView() {
        return this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
    }

    protected OWLObjectHierarchyProvider<OWLObject> getHierarchyProvider() {
        return this.m_hierarchyprovider;
    }

    public void disposeView() {
        if (this.m_tree != null) {
            this.m_tree.dispose();
        }
        try {
            this.m_reader.unloadOntology();
        }
        catch (OWLReasonerException oWLReasonerException) {
            oWLReasonerException.printStackTrace();
        }
    }

    private OWLReasoner getProtegeReasoner() {
        OWLModelManager oWLModelManager = this.getOWLModelManager();
        OWLReasoner oWLReasoner = oWLModelManager.getReasoner();
        if (oWLReasoner != null) {
            String string = oWLReasoner.getClass().getSimpleName();
            Util.debug((String)("Protege advertises reasoner '" + string + "'"), (int)4);
            if (string.equals("NoOpReasoner")) {
                Util.debug((String)"I got the NoOpReasoner, so I am not using it...", (int)3);
                oWLReasoner = null;
            }
        }
        return oWLReasoner;
    }

    private OntologyReader createOntologyReader() {
        OWLModelManager oWLModelManager = this.getOWLModelManager();
        OntologyReader ontologyReader = new OntologyReader(oWLModelManager.getOntologies(), oWLModelManager.getOWLOntologyManager(), this.getProtegeReasoner());
        for (HierarchyRuleSet hierarchyRuleSet : ontologyReader.getHierarchyRuleSets()) {
            if (!(hierarchyRuleSet instanceof SubclassTypeHierarchyRuleSet)) continue;
            ontologyReader.setHierarchyRuleSet(hierarchyRuleSet);
        }
        return ontologyReader;
    }
}

