/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.protege;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glowvis.protege.ClassHierarchyProviderAdapter;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.IndividualsByInferredTypeHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.IndividualsByTypeHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManager;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLObject> {
    private OWLObject m_root;
    private List<OWLObjectHierarchyProvider<OWLObject>> m_providers;
    private OWLModelManagerListener owlModelManagerListener;

    protected HierarchyProvider(OWLModelManager oWLModelManager, OWLOntologyManager oWLOntologyManager) {
        super(oWLOntologyManager);
        this.m_root = oWLOntologyManager.getOWLDataFactory().getOWLThing();
        this.m_providers = new ArrayList<OWLObjectHierarchyProvider<OWLObject>>();
        this.m_providers.add(new ClassHierarchyProviderAdapter(this.getClassHierarchyProvider(oWLModelManager, false)));
        this.m_providers.add(this.getIndividualsByTypeHierarchyProvider(oWLModelManager, false));
        this.owlModelManagerListener = new OWLModelManagerListener(){

            public void handleChange(OWLModelManagerChangeEvent oWLModelManagerChangeEvent) {
                if (oWLModelManagerChangeEvent.isType(EventType.REASONER_CHANGED) || oWLModelManagerChangeEvent.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || oWLModelManagerChangeEvent.isType(EventType.ONTOLOGY_CLASSIFIED) || oWLModelManagerChangeEvent.isType(EventType.ONTOLOGY_RELOADED)) {
                    HierarchyProvider.this.fireHierarchyChanged();
                }
            }
        };
        oWLModelManager.addListener(this.owlModelManagerListener);
    }

    private OWLObjectHierarchyProvider<OWLClass> getClassHierarchyProvider(OWLModelManager oWLModelManager, boolean bl) {
        OWLHierarchyManager oWLHierarchyManager = oWLModelManager.getOWLHierarchyManager();
        if (bl) {
            return oWLHierarchyManager.getInferredOWLClassHierarchyProvider();
        }
        return oWLHierarchyManager.getOWLClassHierarchyProvider();
    }

    private OWLObjectHierarchyProvider<OWLObject> getIndividualsByTypeHierarchyProvider(OWLModelManager oWLModelManager, boolean bl) {
        if (bl) {
            IndividualsByInferredTypeHierarchyProvider individualsByInferredTypeHierarchyProvider = new IndividualsByInferredTypeHierarchyProvider(oWLModelManager.getOWLOntologyManager());
            individualsByInferredTypeHierarchyProvider.setReasoner(oWLModelManager.getReasoner());
            return individualsByInferredTypeHierarchyProvider;
        }
        return new IndividualsByTypeHierarchyProvider(oWLModelManager.getOWLOntologyManager());
    }

    private List<OWLObjectHierarchyProvider<OWLObject>> getProviders() {
        return this.m_providers;
    }

    public Set<OWLObject> getRoots() {
        return Collections.singleton(this.m_root);
    }

    public Set<OWLObject> getChildren(OWLObject oWLObject) {
        HashSet<OWLObject> hashSet = new HashSet<OWLObject>();
        for (OWLObjectHierarchyProvider<OWLObject> oWLObjectHierarchyProvider : this.getProviders()) {
            hashSet.addAll(oWLObjectHierarchyProvider.getChildren(oWLObject));
        }
        return hashSet;
    }

    public boolean containsReference(OWLObject oWLObject) {
        for (OWLObjectHierarchyProvider<OWLObject> oWLObjectHierarchyProvider : this.getProviders()) {
            if (!oWLObjectHierarchyProvider.containsReference(oWLObject)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLObject> getEquivalents(OWLObject oWLObject) {
        HashSet<OWLObject> hashSet = new HashSet<OWLObject>();
        for (OWLObjectHierarchyProvider<OWLObject> oWLObjectHierarchyProvider : this.getProviders()) {
            hashSet.addAll(oWLObjectHierarchyProvider.getEquivalents(oWLObject));
        }
        return hashSet;
    }

    public Set<OWLObject> getParents(OWLObject oWLObject) {
        HashSet<OWLObject> hashSet = new HashSet<OWLObject>();
        for (OWLObjectHierarchyProvider<OWLObject> oWLObjectHierarchyProvider : this.getProviders()) {
            hashSet.addAll(oWLObjectHierarchyProvider.getParents(oWLObject));
        }
        return hashSet;
    }

    public void setOntologies(Set<OWLOntology> set) {
        for (OWLObjectHierarchyProvider<OWLObject> oWLObjectHierarchyProvider : this.getProviders()) {
            oWLObjectHierarchyProvider.setOntologies(set);
        }
    }
}

