/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.protege;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glowvis.owlapi.OntologyReader;
import org.glowvis.owlapi.access.NotSupportedException;
import org.glowvis.owlapi.data.ClassNode;
import org.glowvis.owlapi.data.Node;
import org.glowvis.owlapi.ruleset.hierarchy.HierarchyRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.NodeFinder;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProviderListener;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyProviderAdapter
implements OWLObjectHierarchyProvider<OWLObject> {
    private OntologyReader m_reader;

    public HierarchyProviderAdapter(OntologyReader ontologyReader) {
        this.m_reader = ontologyReader;
    }

    public Set<OWLObject> getRoots() {
        return Collections.singleton(this.m_reader.getThing());
    }

    public Set<OWLObject> getChildren(OWLObject oWLObject) {
        HashSet<OWLObject> hashSet = new HashSet<OWLObject>();
        if (oWLObject instanceof OWLClass) {
            ClassNode classNode = new ClassNode((OWLClass)oWLObject);
            HierarchyRuleSet hierarchyRuleSet = this.m_reader.getCurrentHierarchyRuleSet();
            for (NodeFinder nodeFinder : hierarchyRuleSet.getNodeFinders()) {
                try {
                    for (Node node : nodeFinder.getChildNodes((Node)classNode)) {
                        hashSet.add(node.getContent());
                    }
                }
                catch (OWLReasonerException oWLReasonerException) {
                    oWLReasonerException.printStackTrace();
                }
                catch (NotSupportedException notSupportedException) {
                    notSupportedException.printStackTrace();
                }
            }
        }
        return hashSet;
    }

    public void addListener(OWLObjectHierarchyProviderListener<OWLObject> oWLObjectHierarchyProviderListener) {
    }

    public boolean containsReference(OWLObject oWLObject) {
        return false;
    }

    public void dispose() {
    }

    public Set<OWLObject> getAncestors(OWLObject oWLObject) {
        return Collections.emptySet();
    }

    public Set<OWLObject> getDescendants(OWLObject oWLObject) {
        return Collections.emptySet();
    }

    public Set<OWLObject> getEquivalents(OWLObject oWLObject) {
        return Collections.emptySet();
    }

    public Set<OWLObject> getParents(OWLObject oWLObject) {
        return Collections.emptySet();
    }

    public Set<List<OWLObject>> getPathsToRoot(OWLObject oWLObject) {
        return Collections.emptySet();
    }

    public void removeListener(OWLObjectHierarchyProviderListener<OWLObject> oWLObjectHierarchyProviderListener) {
    }

    public void setOntologies(Set<OWLOntology> set) {
    }
}

