/*
 * Decompiled with CFR 0.152.
 */
package org.glowvis.protege;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.glowvis.data.CompoundGraph;
import org.glowvis.data.Configuration;
import org.glowvis.owlapi.OntologyReader;
import org.glowvis.owlapi.RuleSetNotSelectedException;
import org.glowvis.owlapi.Util;
import org.glowvis.owlapi.access.NotSupportedException;
import org.glowvis.owlapi.ruleset.edge.EdgeRuleSet;
import org.glowvis.owlapi.ruleset.hierarchy.HierarchyRuleSet;
import org.glowvis.protege.AdvancedConfigurationFrame;
import org.glowvis.protege.HelpFrame;
import org.glowvis.vis.gl.GLRadialCompoundGraphDisplay;
import org.glowvis.vis.gl.render.GLHierarchicallyBundledEdgeRenderer;
import org.glowvis.vis.gl.render.GLLabelRenderer;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.view.AbstractOWLClassViewComponent;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLOntologyManager;

public class ViewComponent
extends AbstractOWLClassViewComponent
implements ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 346225585263535586L;
    private static final String REASONER_ASSERTED = "Asserted";
    private static final String REASONER_INFERRED = "Inferred";
    private static final int NONE = -1;
    private static final boolean useThreading = false;
    private GLRadialCompoundGraphDisplay m_display;
    private JLabel m_statusLabel;
    private JComboBox m_hierarchyDropdown;
    private JComboBox m_edgeDropdown;
    private JComboBox m_reasonerDropdown;
    private JComboBox m_layoutDropdown;
    private JComboBox m_labelingDropdown;
    private JSlider m_bundlingSlider;
    private OntologyReader m_reader;
    private JFrame m_advancedConfigurationFrame;
    private JFrame m_helpFrame;
    private OWLClass m_selectedClass;
    private HierarchyRuleSet m_hierarchyRuleSet;
    private EdgeRuleSet m_edgeRuleSet;
    private String m_reasonerName;
    private GLRadialCompoundGraphDisplay.GraphLayoutOption m_layoutIndex;
    private double m_bundlingCoefficient = -1.0;
    private CompoundGraph m_graph;

    public void initialiseClassView() throws Exception {
        Util.debug((String)"initialiseClassView was called", (int)3);
        this.initializeOntologyReader();
        this.initializeWidgets();
        this.selectDefaultRuleSets();
    }

    protected OWLClass updateView(OWLClass oWLClass) {
        Util.debug((String)("updateView called, selectedClass=" + oWLClass), (int)3);
        this.m_selectedClass = oWLClass;
        this.dispatchInitializeVisualization(true);
        return oWLClass;
    }

    public void disposeView() {
        Util.debug((String)"disposeView was called", (int)3);
    }

    private void initializeWidgets() {
        Object object2;
        this.setLayout(new BorderLayout(6, 6));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Knowledge:"));
        this.m_reasonerDropdown = new JComboBox();
        this.m_reasonerDropdown.addItemListener(this);
        this.m_reasonerDropdown.setActionCommand("reasonerSelected");
        this.m_reasonerDropdown.setName("Reasoner");
        this.m_reasonerDropdown.setVisible(true);
        this.m_reasonerDropdown.setLightWeightPopupEnabled(false);
        this.m_reasonerDropdown.addItem(REASONER_ASSERTED);
        this.m_reasonerDropdown.addItem(REASONER_INFERRED);
        box.add(this.m_reasonerDropdown);
        box.add(new JLabel("Hierarchy:"));
        this.m_hierarchyDropdown = new JComboBox();
        this.m_hierarchyDropdown.addItemListener(this);
        this.m_hierarchyDropdown.setActionCommand("hierarchySelected");
        this.m_hierarchyDropdown.setName("Hierarchy");
        this.m_hierarchyDropdown.setVisible(true);
        this.m_hierarchyDropdown.setLightWeightPopupEnabled(false);
        box.add(this.m_hierarchyDropdown);
        box.add(new JLabel("Adjacencies:"));
        this.m_edgeDropdown = new JComboBox();
        this.m_edgeDropdown.addItemListener(this);
        this.m_edgeDropdown.setActionCommand("edgeSelected");
        this.m_edgeDropdown.setName("Edge");
        this.m_edgeDropdown.setVisible(true);
        this.m_edgeDropdown.setLightWeightPopupEnabled(false);
        box.add(this.m_edgeDropdown);
        JButton jButton = new JButton();
        jButton.setText("Update");
        jButton.setMnemonic(85);
        jButton.setActionCommand("update");
        jButton.addActionListener(this);
        box.add(jButton);
        this.add(box, "First");
        Box box2 = Box.createHorizontalBox();
        JButton jButton2 = new JButton();
        jButton2.setText("Help");
        jButton2.setMnemonic(72);
        jButton2.setActionCommand("help");
        jButton2.addActionListener(this);
        box2.add(jButton2);
        this.m_statusLabel = new JLabel();
        this.setStatus("");
        box2.add(Box.createHorizontalGlue());
        box2.add(new JLabel("Layout:"));
        this.m_layoutDropdown = new JComboBox();
        this.m_layoutDropdown.addItemListener(this);
        this.m_layoutDropdown.setActionCommand("layoutSelected");
        this.m_layoutDropdown.setName("layout");
        this.m_layoutDropdown.setVisible(true);
        this.m_layoutDropdown.setLightWeightPopupEnabled(false);
        Configuration configuration = this.getDefaultConfiguration();
        Configuration.ConfigurationEnumItem configurationEnumItem = (Configuration.ConfigurationEnumItem)configuration.getItem("Layout");
        for (Object object2 : configurationEnumItem.getItems()) {
            this.m_layoutDropdown.addItem(new OptionItem<GLRadialCompoundGraphDisplay.GraphLayoutOption>((GLRadialCompoundGraphDisplay.GraphLayoutOption)object2));
        }
        box2.add(this.m_layoutDropdown);
        box2.add(new JLabel("Labels:"));
        this.m_labelingDropdown = new JComboBox();
        this.m_labelingDropdown.addItemListener(this);
        this.m_labelingDropdown.setActionCommand("labelingSelected");
        this.m_labelingDropdown.setName("labeling");
        this.m_labelingDropdown.setVisible(true);
        this.m_labelingDropdown.setLightWeightPopupEnabled(false);
        GLLabelRenderer.GLLabelRendererConfiguration gLLabelRendererConfiguration = (GLLabelRenderer.GLLabelRendererConfiguration)configuration.getSubgroup("Labels");
        for (GLLabelRenderer.GLLabelRendererConfiguration.LabelDisplayOption labelDisplayOption : gLLabelRendererConfiguration.generateLabelDisplayOptions()) {
            this.m_labelingDropdown.addItem(new OptionItem<GLLabelRenderer.GLLabelRendererConfiguration.LabelDisplayOption>(labelDisplayOption));
        }
        this.m_labelingDropdown.setSelectedIndex(3);
        box2.add(this.m_labelingDropdown);
        box2.add(new JLabel("Bundling:"));
        this.m_bundlingSlider = new JSlider(0, 100);
        this.m_bundlingSlider.addChangeListener(this);
        this.m_bundlingSlider.setName("bundling");
        this.m_bundlingSlider.setVisible(true);
        this.m_bundlingSlider.setValue((int)Math.round(this.getConfigBundlingCoefficient(configuration) * (double)this.m_bundlingSlider.getMaximum()));
        box2.add(this.m_bundlingSlider);
        object2 = new JButton();
        ((AbstractButton)object2).setText("Advanced...");
        ((AbstractButton)object2).setMnemonic(65);
        ((AbstractButton)object2).setActionCommand("advanced");
        ((AbstractButton)object2).addActionListener(this);
        box2.add((Component)object2);
        this.add(box2, "Last");
        Util.debug((String)"Layout initialized", (int)3);
    }

    private Configuration getDefaultConfiguration() {
        Configuration configuration = GLRadialCompoundGraphDisplay.createDefaultConfiguration();
        return configuration;
    }

    private OWLReasoner getReasoner() {
        if (REASONER_ASSERTED.equals(this.m_reasonerName)) {
            return null;
        }
        return this.getProtegeReasoner();
    }

    private OWLReasoner getProtegeReasoner() {
        OWLModelManager oWLModelManager = this.getOWLModelManager();
        OWLReasoner oWLReasoner = oWLModelManager.getReasoner();
        if (oWLReasoner != null) {
            String string = oWLReasoner.getClass().getSimpleName();
            Util.debug((String)("Protege advertises reasoner '" + string + "'"), (int)4);
            if (string.equals("NoOpReasoner")) {
                Util.debug((String)"I got the NoOpReasoner, so I am not using it...", (int)3);
                oWLReasoner = null;
            }
        }
        return oWLReasoner;
    }

    private GLRadialCompoundGraphDisplay createDisplay() {
        GLRadialCompoundGraphDisplay gLRadialCompoundGraphDisplay = new GLRadialCompoundGraphDisplay();
        Util.debug((String)"Display created", (int)3);
        return gLRadialCompoundGraphDisplay;
    }

    private void populateHierarchyBox() {
        this.m_hierarchyDropdown.removeAllItems();
        for (HierarchyRuleSet hierarchyRuleSet : this.m_reader.getHierarchyRuleSets()) {
            this.m_hierarchyDropdown.addItem(hierarchyRuleSet);
        }
    }

    private void populateEdgeBox(HierarchyRuleSet hierarchyRuleSet) {
        this.m_edgeDropdown.removeAllItems();
        for (EdgeRuleSet edgeRuleSet : hierarchyRuleSet.getEdgeRuleSets()) {
            this.m_edgeDropdown.addItem(edgeRuleSet);
        }
    }

    private void selectHierarchyRuleSet(HierarchyRuleSet hierarchyRuleSet) {
        if (hierarchyRuleSet.equals(this.m_hierarchyRuleSet)) {
            Util.debug((String)("HierarchyRuleSet chosen (" + hierarchyRuleSet + ") is same as hierarchyRuleSet already present (" + this.m_hierarchyRuleSet + ")"), (int)2);
            return;
        }
        Util.debug((String)("HierarchyRuleSet selected: " + hierarchyRuleSet), (int)3);
        this.m_hierarchyRuleSet = hierarchyRuleSet;
        this.populateEdgeBox(hierarchyRuleSet);
    }

    private void selectEdgeRuleSet(EdgeRuleSet edgeRuleSet) {
        if (edgeRuleSet != null && edgeRuleSet.equals(this.m_edgeRuleSet)) {
            Util.debug((String)("EdgeRuleSet chosen (" + edgeRuleSet + ") is same as edgeRuleSet already present (" + this.m_edgeRuleSet + ")"), (int)2);
            return;
        }
        Util.debug((String)("EdgeRuleSet selected: " + edgeRuleSet), (int)3);
        HierarchyRuleSet hierarchyRuleSet = null;
        if (edgeRuleSet != null) {
            hierarchyRuleSet = edgeRuleSet.getHierarchyRuleSet();
        }
        this.m_hierarchyRuleSet = hierarchyRuleSet;
        this.m_edgeRuleSet = edgeRuleSet;
        this.dispatchInitializeVisualization(true);
    }

    private void selectReasoner(String string) {
        if (REASONER_INFERRED.equals(string) && this.getProtegeReasoner() == null) {
            this.showError("To use inferred knowledge, you must first select a reasoner in Protege.");
            this.m_reasonerDropdown.setSelectedItem(REASONER_ASSERTED);
            return;
        }
        this.m_reasonerName = string;
        this.dispatchInitializeVisualization(true);
    }

    private void selectLayout(GLRadialCompoundGraphDisplay.GraphLayoutOption graphLayoutOption) {
        this.m_layoutIndex = graphLayoutOption;
        this.dispatchInitializeVisualization(false);
    }

    private void selectBundlingCoefficient(float f) {
        this.m_bundlingCoefficient = f;
        if (this.m_display != null) {
            Configuration configuration = this.m_display.getApplicationConfiguration();
            if (this.m_bundlingCoefficient != -1.0) {
                this.setConfigBundlingCoefficient(configuration, this.m_bundlingCoefficient);
            }
        }
    }

    private void selectDefaultRuleSets() {
        this.populateHierarchyBox();
    }

    private void setStatus(String string) {
        if (string == null || string.equals("")) {
            string = " ";
        }
        if (this.m_statusLabel != null) {
            this.m_statusLabel.setText(string);
        }
    }

    private synchronized void initializeVisualization(boolean bl) throws OWLReasonerException, RuleSetNotSelectedException, NotSupportedException {
        boolean bl2;
        boolean bl3;
        Util.debug((String)"initializeVisualization called", (int)4);
        if (this.m_reader == null) {
            Util.debug((String)"No OntologyReader present, cannot create visualization yet", (int)2);
            return;
        }
        if (this.m_hierarchyRuleSet == null) {
            Util.debug((String)"No HierarchyRuleSet selected, cannot create visualization yet", (int)2);
            return;
        }
        if (this.m_edgeRuleSet == null) {
            Util.debug((String)"No EdgeRuleSet selected, cannot create visualization yet", (int)2);
            return;
        }
        boolean bl4 = bl3 = this.m_graph != null;
        if (!bl && bl3) {
            Util.debug((String)"Skipping graph building: buildGraph is false and an old graph exists", (int)4);
        } else {
            Util.debug((String)"Creating graph", (int)4);
            this.m_graph = this.createGraph();
        }
        boolean bl5 = bl2 = this.m_display != null;
        if (!bl2) {
            Util.debug((String)"Creating new display", (int)4);
            this.m_display = this.createDisplay();
        }
        Configuration configuration = this.m_display.getApplicationConfiguration();
        configuration.getItem("Layout").setValue((Object)this.m_layoutIndex);
        if (this.m_bundlingCoefficient != -1.0) {
            this.setConfigBundlingCoefficient(configuration, this.m_bundlingCoefficient);
        }
        Util.debug((String)"Passing graph to display", (int)4);
        this.m_display.setGraph(this.m_graph);
        if (!bl2) {
            Util.debug((String)"Adding display to panel", (int)4);
            this.add((Component)this.m_display, "Center");
        }
        Util.debug((String)"Done", (int)3);
    }

    public Configuration getDisplayConfiguration() {
        Configuration configuration = null;
        if (this.m_display != null) {
            configuration = this.m_display.getApplicationConfiguration();
        }
        return configuration;
    }

    private void dispatchInitializeVisualization(boolean bl) {
        this.performInitializeVisualization(bl);
    }

    private void performInitializeVisualization(boolean bl) {
        try {
            this.setStatus("Calculating graph...");
            this.initializeVisualization(bl);
            this.setStatus("");
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void handleException(Exception exception) {
        Util.debug((String)("Exception caught: " + exception));
        Util.debug((String)("Stack trace: \n" + Util.printStackTrace((Exception)exception)));
        String string = exception.getMessage();
        if (string == null || "".equals(string)) {
            string = "An unexpected error occurred: " + exception.getClass().getSimpleName();
        }
        this.showError(string);
    }

    private void showError(String string) {
        Util.debug((String)("Error message displayed: '" + string + "'"));
        JOptionPane.showMessageDialog((Component)((Object)this), string, "GLOW Error", 0);
    }

    private void initializeOntologyReader() {
        OWLModelManager oWLModelManager = this.getOWLModelManager();
        Set set = oWLModelManager.getOntologies();
        OWLOntologyManager oWLOntologyManager = oWLModelManager.getOWLOntologyManager();
        OWLReasoner oWLReasoner = this.getReasoner();
        this.m_reader = new OntologyReader(set, oWLOntologyManager, oWLReasoner);
        Util.debug((String)"Ontology reader initialized", (int)3);
    }

    private void openAdvancedConfigurationFrame() {
        if (this.m_advancedConfigurationFrame == null) {
            this.m_advancedConfigurationFrame = new AdvancedConfigurationFrame(this.getDisplayConfiguration());
        }
        this.m_advancedConfigurationFrame.setVisible(true);
    }

    private void openHelpFrame() {
        if (this.m_helpFrame == null) {
            this.m_helpFrame = new HelpFrame();
        }
        this.m_helpFrame.setVisible(true);
    }

    private CompoundGraph createGraph() throws OWLReasonerException, RuleSetNotSelectedException, NotSupportedException {
        Util.debug((String)"Configuring OntologyReader", (int)2);
        this.m_reader.setReasoner(this.getOWLModelManager().getOWLOntologyManager(), this.getReasoner());
        this.m_reader.setHierarchyRuleSet(this.m_hierarchyRuleSet);
        this.m_reader.setEdgeRuleSet(this.m_edgeRuleSet);
        Util.debug((String)("Getting tree from reader, root class = " + this.m_selectedClass), (int)2);
        CompoundGraph compoundGraph = this.m_reader.createCompoundGraph(this.m_selectedClass);
        return compoundGraph;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Util.debug((String)("Event: ID " + actionEvent.getID() + ", source: " + actionEvent.getSource()), (int)4);
        try {
            if ("update".equals(actionEvent.getActionCommand())) {
                this.initializeVisualization(false);
            } else if ("advanced".equals(actionEvent.getActionCommand())) {
                this.openAdvancedConfigurationFrame();
            } else if ("help".equals(actionEvent.getActionCommand())) {
                this.openHelpFrame();
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        Util.debug((String)("Item Event: ID " + itemEvent.getID() + ", source: " + itemEvent.getSource()), (int)4);
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (jComboBox.equals(this.m_hierarchyDropdown)) {
            HierarchyRuleSet hierarchyRuleSet = (HierarchyRuleSet)jComboBox.getSelectedItem();
            this.selectHierarchyRuleSet(hierarchyRuleSet);
        } else if (jComboBox.equals(this.m_edgeDropdown)) {
            EdgeRuleSet edgeRuleSet = (EdgeRuleSet)jComboBox.getSelectedItem();
            this.selectEdgeRuleSet(edgeRuleSet);
        } else if (jComboBox.equals(this.m_reasonerDropdown)) {
            String string = (String)jComboBox.getSelectedItem();
            this.selectReasoner(string);
        } else if (jComboBox.equals(this.m_layoutDropdown)) {
            OptionItem optionItem = (OptionItem)jComboBox.getSelectedItem();
            this.selectLayout((GLRadialCompoundGraphDisplay.GraphLayoutOption)optionItem.getIndex());
        } else if (jComboBox.equals(this.m_labelingDropdown)) {
            OptionItem optionItem = (OptionItem)jComboBox.getSelectedItem();
            Configuration configuration = this.getDisplayConfiguration();
            if (configuration != null) {
                GLLabelRenderer.GLLabelRendererConfiguration gLLabelRendererConfiguration = (GLLabelRenderer.GLLabelRendererConfiguration)configuration.getSubgroup("Labels");
                gLLabelRendererConfiguration.setLabelDisplayOption((GLLabelRenderer.GLLabelRendererConfiguration.LabelDisplayOption)optionItem.getIndex());
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        float f = (float)jSlider.getValue() / (float)jSlider.getMaximum();
        this.selectBundlingCoefficient(f);
    }

    private GLHierarchicallyBundledEdgeRenderer.GLBundlingEdgeRendererConfiguration getBundledEdgeRendererConfig(Configuration configuration) {
        return (GLHierarchicallyBundledEdgeRenderer.GLBundlingEdgeRendererConfiguration)configuration.getSubgroup("Adjacency edges");
    }

    private double getConfigBundlingCoefficient(Configuration configuration) {
        return this.getBundledEdgeRendererConfig(configuration).getBundlingCoefficient();
    }

    private void setConfigBundlingCoefficient(Configuration configuration, double d) {
        this.getBundledEdgeRendererConfig(configuration).setBundlingCoefficient(d);
    }

    private class VisualizationThread
    extends Thread {
        private boolean m_buildGraph;

        public VisualizationThread(boolean bl) {
            this.m_buildGraph = bl;
        }

        public void run() {
            ViewComponent.this.performInitializeVisualization(this.m_buildGraph);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OptionItem<T> {
        private T m_index;

        public OptionItem(T t) {
            this.m_index = t;
        }

        public T getIndex() {
            return this.m_index;
        }

        public String toString() {
            return this.m_index.toString();
        }
    }
}

